/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases.oracle;

import io.debezium.testing.system.tools.AbstractDockerDeployer;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.databases.oracle.DockerOracleController;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.OracleContainer;
import org.testcontainers.utility.DockerImageName;

public final class DockerOracleDeployer
extends AbstractDockerDeployer<DockerOracleController, OracleContainer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerOracleDeployer.class);

    private DockerOracleDeployer(OracleContainer container) {
        super(container);
    }

    @Override
    protected DockerOracleController getController(OracleContainer container) {
        return new DockerOracleController(container);
    }

    public static class Builder
    extends AbstractDockerDeployer.DockerBuilder<Builder, OracleContainer, DockerOracleDeployer> {
        public Builder() {
            this(new OracleContainer(DockerImageName.parse((String)ConfigProperties.DOCKER_IMAGE_ORACLE).asCompatibleSubstituteFor("gvenzl/oracle-xe")));
        }

        public Builder(OracleContainer container) {
            super(container);
        }

        @Override
        public DockerOracleDeployer build() {
            ((OracleContainer)this.container).withDatabaseName(ConfigProperties.DATABASE_ORACLE_PDBNAME).withUsername(ConfigProperties.DATABASE_ORACLE_USERNAME).withPassword(ConfigProperties.DATABASE_ORACLE_PASSWORD).withStartupTimeout(Duration.of(15L, ChronoUnit.MINUTES));
            return new DockerOracleDeployer((OracleContainer)this.container);
        }
    }
}

