/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases.mongodb.sharded;

import io.debezium.testing.system.tools.Deployer;
import io.debezium.testing.system.tools.databases.mongodb.sharded.MongoShardKey;
import io.debezium.testing.system.tools.databases.mongodb.sharded.OcpMongoShardedCluster;
import io.debezium.testing.system.tools.databases.mongodb.sharded.OcpMongoShardedController;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpMongoShardedDeployer
implements Deployer<OcpMongoShardedController> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpMongoShardedDeployer.class);
    private final OpenShiftClient ocp;
    private final String project;
    private final int shardCount;
    private final int replicaCount;
    private final int configServerCount;
    private final String rootUserName;
    private final String rootPassword;
    private final boolean useInternalAuth;
    private List<MongoShardKey> shardKeys;
    private OcpMongoShardedCluster mongo;

    public OcpMongoShardedDeployer(int shardCount, int replicaCount, int configServerCount, String rootUserName, String rootPassword, boolean useInternalAuth, OpenShiftClient ocp, String project, List<MongoShardKey> shardKeys) {
        this.shardCount = shardCount;
        this.replicaCount = replicaCount;
        this.configServerCount = configServerCount;
        this.rootUserName = rootUserName;
        this.rootPassword = rootPassword;
        this.useInternalAuth = useInternalAuth;
        this.ocp = ocp;
        this.project = project;
        this.shardKeys = shardKeys;
    }

    public OcpMongoShardedController getController() {
        return new OcpMongoShardedController(this.mongo, this.ocp, this.project);
    }

    @Override
    public OcpMongoShardedController deploy() throws Exception {
        LOGGER.info("Deploying sharded mongo cluster");
        this.mongo = OcpMongoShardedCluster.builder().withOcp(this.ocp).withProject(this.project).withConfigServerCount(this.configServerCount).withInitialShardCount(this.shardCount).withReplicaCount(this.replicaCount).withShardKeys(this.shardKeys).withUseInternalAuth(this.useInternalAuth).withRootUser(this.rootUserName, this.rootPassword).withShardKeys(this.shardKeys).build();
        this.mongo.start();
        return new OcpMongoShardedController(this.mongo, this.ocp, this.project);
    }

    public static OcpMongoShardedDeployerBuilder builder() {
        return new OcpMongoShardedDeployerBuilder();
    }

    public static final class OcpMongoShardedDeployerBuilder {
        private OpenShiftClient ocp;
        private String project;
        private int shardCount;
        private int replicaCount;
        private int configServerCount;
        private String rootUserName;
        private String rootPassword;
        private boolean useInternalAuth;
        private List<MongoShardKey> shardKeys;

        private OcpMongoShardedDeployerBuilder() {
        }

        public OcpMongoShardedDeployerBuilder withOcp(OpenShiftClient ocp) {
            this.ocp = ocp;
            return this;
        }

        public OcpMongoShardedDeployerBuilder withProject(String project) {
            this.project = project;
            return this;
        }

        public OcpMongoShardedDeployerBuilder withShardCount(int shardCount) {
            this.shardCount = shardCount;
            return this;
        }

        public OcpMongoShardedDeployerBuilder withReplicaCount(int replicaCount) {
            this.replicaCount = replicaCount;
            return this;
        }

        public OcpMongoShardedDeployerBuilder withConfigServerCount(int configServerCount) {
            this.configServerCount = configServerCount;
            return this;
        }

        public OcpMongoShardedDeployerBuilder withRootUser(String rootUserName, String rootPassword) {
            this.rootUserName = rootUserName;
            this.rootPassword = rootPassword;
            return this;
        }

        public OcpMongoShardedDeployerBuilder withUseInternalAuth(boolean useInternalAuth) {
            this.useInternalAuth = useInternalAuth;
            return this;
        }

        public OcpMongoShardedDeployerBuilder withShardKeys(List<MongoShardKey> shardKeys) {
            this.shardKeys = shardKeys;
            return this;
        }

        public OcpMongoShardedDeployer build() {
            return new OcpMongoShardedDeployer(this.shardCount, this.replicaCount, this.configServerCount, this.rootUserName, this.rootPassword, this.useInternalAuth, this.ocp, this.project, this.shardKeys);
        }
    }
}

