/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases.mongodb.sharded;

import io.debezium.testing.system.tools.OpenShiftUtils;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.client.OpenShiftClient;
import org.testcontainers.lifecycle.Startable;

public class OcpMongoDeploymentManager
implements Startable {
    private Deployment deployment;
    private Service service;
    private final String serviceUrl;
    private final OpenShiftClient ocp;
    private final OpenShiftUtils ocpUtils;
    private final String project;

    public OcpMongoDeploymentManager(Deployment deployment, Service service, String serviceUrl, OpenShiftClient ocp, String project) {
        this.deployment = deployment;
        this.service = service;
        this.serviceUrl = serviceUrl;
        this.ocp = ocp;
        this.ocpUtils = new OpenShiftUtils(ocp);
        this.project = project;
    }

    public void start() {
        this.deployment = (Deployment)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).createOrReplace((Object[])new Deployment[]{this.deployment});
        this.service = (Service)((NonNamespaceOperation)this.ocp.services().inNamespace(this.project)).createOrReplace((Object[])new Service[]{this.service});
    }

    public void stop() {
        this.ocpUtils.scaleDeploymentToZero(this.deployment);
    }

    public void waitForStopped() {
        this.ocpUtils.waitForDeploymentToScaleDown(this.deployment);
    }

    public String getHostname() {
        return this.service.getMetadata().getName() + "." + this.project + ".svc.cluster.local";
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public Service getService() {
        return this.service;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public OpenShiftClient getOcp() {
        return this.ocp;
    }

    public OpenShiftUtils getOcpUtils() {
        return this.ocpUtils;
    }

    public String getProject() {
        return this.project;
    }
}

