/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools;

import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.WaitConditions;
import io.debezium.testing.system.tools.databases.DatabaseExecListener;
import io.debezium.testing.system.tools.operatorutil.OpenshiftOperatorEnum;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicy;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyFluent;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorChannelable;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.RouteSpecFluent;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroup;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupSpecBuilder;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenShiftUtils.class);
    private OpenShiftClient client;

    public OpenShiftUtils(OpenShiftClient client) {
        this.client = client;
    }

    public Route createRoute(String project, String name, String service, String port, Map<String, String> labels) {
        return (Route)((NonNamespaceOperation)this.client.routes().inNamespace(project)).createOrReplace((Object[])new Route[]{((RouteBuilder)((RouteFluent.SpecNested)((RouteSpecFluent.PortNested)((RouteFluent.SpecNested)((RouteSpecFluent.ToNested)((RouteSpecFluent.ToNested)((RouteBuilder)((RouteFluent.MetadataNested)((RouteFluent.MetadataNested)new RouteBuilder().withNewMetadata().withName(name)).withLabels(labels)).endMetadata()).withNewSpec().withNewTo().withKind("Service")).withName(service)).endTo()).withNewPort().withNewTargetPort(port)).endPort()).endSpec()).build()});
    }

    public Service createService(String project, String name, String portName, int port, Map<String, String> selector, Map<String, String> labels) {
        return (Service)((NonNamespaceOperation)this.client.services().inNamespace(project)).createOrReplace((Object[])new Service[]{((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(name)).withLabels(labels)).endMetadata()).withNewSpec().addNewPort().withProtocol("TCP")).withName(portName)).withPort(Integer.valueOf(port))).withTargetPort(new IntOrString(Integer.valueOf(port)))).endPort()).withSelector(selector)).endSpec()).build()});
    }

    public NetworkPolicy createNetworkPolicy(String project, String name, Map<String, String> podSelectorLabels, List<NetworkPolicyPort> ports) {
        NetworkPolicy policy = (NetworkPolicy)((NonNamespaceOperation)this.client.network().networkPolicies().inNamespace(project)).createOrReplace((Object[])new NetworkPolicy[]{((NetworkPolicyBuilder)((NetworkPolicyFluent.SpecNested)((NetworkPolicyFluent.SpecNested)((NetworkPolicySpecFluent.IngressNested)((NetworkPolicyFluent.SpecNested)((NetworkPolicySpecFluent.PodSelectorNested)((NetworkPolicyBuilder)((NetworkPolicyFluent.MetadataNested)new NetworkPolicyBuilder().withNewMetadata().withName(name)).endMetadata()).withNewSpec().withNewPodSelector().withMatchLabels(podSelectorLabels)).endPodSelector()).addNewIngress().addToPorts(ports.toArray(new NetworkPolicyPort[0]))).endIngress()).withPolicyTypes(new String[]{"Ingress"})).endSpec()).build()});
        return policy;
    }

    public ServiceAccount linkPullSecret(String project, String account, String secret) {
        return (ServiceAccount)((Resource)((NonNamespaceOperation)this.client.serviceAccounts().inNamespace(project)).withName(account)).edit(sa -> ((ServiceAccountBuilder)((ServiceAccountFluent.SecretsNested)((ServiceAccountBuilder)((ServiceAccountBuilder)((ServiceAccountBuilder)new ServiceAccountBuilder(sa).removeFromImagePullSecrets(new LocalObjectReference[]{new LocalObjectReference(secret)})).addNewImagePullSecret(secret)).removeMatchingFromSecrets(r -> r.getName().equals(secret))).addNewSecret().withName(secret)).endSecret()).build());
    }

    public ServiceAccount linkPullSecret(String project, String account, Secret secret) {
        return this.linkPullSecret(project, account, secret.getMetadata().getName());
    }

    public void ensureHasEnv(Deployment deployment, EnvVar envVar) {
        deployment.getSpec().getTemplate().getSpec().getContainers().forEach(c -> this.ensureHasEnv((Container)c, envVar));
    }

    public void ensureNoEnv(Deployment deployment, String envVar) {
        deployment.getSpec().getTemplate().getSpec().getContainers().forEach(c -> this.ensureNoEnv((Container)c, envVar));
    }

    public void ensureHasEnv(Container container, EnvVar envVar) {
        ArrayList<EnvVar> env = container.getEnv();
        if (env == null) {
            env = new ArrayList<EnvVar>();
            container.setEnv(env);
        }
        env.removeIf(var -> Objects.equals(var.getName(), envVar.getName()));
        env.add(envVar);
    }

    public void ensureNoEnv(Container container, String envVar) {
        List env = container.getEnv();
        if (env == null) {
            return;
        }
        env.removeIf(var -> Objects.equals(var.getName(), envVar));
    }

    public void ensureHasPullSecret(Deployment deployment, String secret) {
        LOGGER.info("Using " + secret + " as image pull secret for deployment '" + deployment.getMetadata().getName() + "'");
        ArrayList<LocalObjectReference> secrets = deployment.getSpec().getTemplate().getSpec().getImagePullSecrets();
        if (secrets == null) {
            secrets = new ArrayList<LocalObjectReference>();
            deployment.getSpec().getTemplate().getSpec().setImagePullSecrets(secrets);
        }
        secrets.removeIf(s -> Objects.equals(secret, s.getName()));
        secrets.add(new LocalObjectReference(secret));
    }

    public List<Pod> podsWithLabels(String project, Map<String, String> labels) {
        Supplier<PodList> podListSupplier = () -> (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(project)).withLabels(labels)).list();
        Awaitility.await().atMost(WaitConditions.scaled(5L), TimeUnit.MINUTES).until(() -> ((PodList)podListSupplier.get()).getItems().size() > 0);
        List pods = podListSupplier.get().getItems();
        if (pods.isEmpty()) {
            LOGGER.warn("Empty PodList");
        }
        return pods;
    }

    public List<Pod> podsForDeployment(Deployment deployment) {
        String project = deployment.getMetadata().getNamespace();
        String name = deployment.getMetadata().getName();
        return this.podsWithLabels(project, Map.of("deployment", name));
    }

    public void waitForPods(String project, Map<String, String> labels) {
        String lbls = labels.keySet().stream().map(k -> k + "=" + (String)labels.get(k)).collect(Collectors.joining(", "));
        LOGGER.info("Waiting for pods to deploy [" + lbls + "]");
        List<Pod> pods = this.podsWithLabels(project, labels);
        for (Pod p : pods) {
            this.client.resource((HasMetadata)p).waitUntilReady(WaitConditions.scaled(5L), TimeUnit.MINUTES);
        }
    }

    public void scaleDeploymentToZero(Deployment deployment) {
        ((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(deployment.getMetadata().getNamespace())).withName(deployment.getMetadata().getName())).scale(0);
        this.waitForDeploymentToScaleDown(deployment);
    }

    public void waitForDeploymentToScaleDown(Deployment deployment) {
        String deploymentName = deployment.getMetadata().getName();
        LOGGER.info("Waiting for deployment [" + deploymentName + "] to scale to 0");
        Supplier<PodList> podListSupplier = () -> (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(deployment.getMetadata().getNamespace())).withLabels(Map.of("deployment", deploymentName))).list();
        Awaitility.await().atMost(WaitConditions.scaled(1L), TimeUnit.MINUTES).pollDelay(5L, TimeUnit.SECONDS).pollInterval(3L, TimeUnit.SECONDS).until(() -> ((PodList)podListSupplier.get()).getItems().isEmpty());
    }

    public Optional<Deployment> deploymentsWithPrefix(String project, String ... prefixes) {
        List deployments = ((DeploymentList)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(project)).list()).getItems();
        return deployments.stream().filter(d -> Arrays.stream(prefixes).anyMatch(prefix -> d.getMetadata().getName().startsWith((String)prefix))).findFirst();
    }

    public void createOrReplaceOperatorGroup(String namespace, String name) {
        OperatorGroup operatorGroup = ((OperatorGroupBuilder)((OperatorGroupBuilder)((OperatorGroupBuilder)((OperatorGroupBuilder)new OperatorGroupBuilder().withApiVersion("operators.coreos.com/v1")).withKind("OperatorGroup")).withMetadata(((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName(name)).withNamespace(namespace)).build())).withSpec(((OperatorGroupSpecBuilder)new OperatorGroupSpecBuilder().withTargetNamespaces(new String[]{namespace})).build())).build();
        ((NonNamespaceOperation)this.client.operatorHub().operatorGroups().inNamespace(namespace)).createOrReplace((Object[])new OperatorGroup[]{operatorGroup});
    }

    public void waitForOperatorDeploymentExists(String namespace, OpenshiftOperatorEnum operator) {
        LOGGER.info("Waiting for operator " + operator.getName() + " to be created");
        Awaitility.await().atMost(WaitConditions.scaled(2L), TimeUnit.MINUTES).pollInterval(Duration.ofSeconds(2L)).until(() -> this.deploymentsWithPrefix(namespace, operator.getDeploymentNamePrefix()).isPresent());
    }

    public static OpenShiftClient createOcpClient() {
        ConfigBuilder configBuilder = new ConfigBuilder();
        ((ConfigBuilder)configBuilder.withRequestRetryBackoffLimit(ConfigProperties.OCP_REQUEST_RETRY_BACKOFF_LIMIT)).withTrustCerts(true);
        return new DefaultOpenShiftClient(configBuilder.build());
    }

    private PodResource<Pod> getPodResource(Pod pod, String project) {
        return (PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(project)).withName(pod.getMetadata().getName());
    }

    public CommandOutputs executeCommand(Deployment deployment, String project, boolean debugLogs, String ... commands) throws InterruptedException {
        ByteArrayOutputStream captureOut = new ByteArrayOutputStream();
        ByteArrayOutputStream captureErr = new ByteArrayOutputStream();
        PrintStream pso = new PrintStream(captureOut);
        PrintStream pse = new PrintStream(captureErr);
        CountDownLatch latch = new CountDownLatch(1);
        List<Pod> pods = this.podsForDeployment(deployment);
        if (pods.size() > 1) {
            throw new IllegalArgumentException("Executing command on deployment scaled to more than 1");
        }
        Pod pod = pods.get(0);
        try (ExecWatch ignored = (ExecWatch)((Execable)((TtyExecErrorChannelable)((TtyExecErrorable)((ContainerResource)this.getPodResource(pod, project).inContainer((Object)((String)pod.getMetadata().getLabels().get("app")))).writingOutput((Object)pso)).writingError((Object)pse)).usingListener((Object)new DatabaseExecListener(deployment.getMetadata().getName(), latch))).exec((Object[])commands);){
            if (debugLogs) {
                LOGGER.info("Waiting on " + deployment.getMetadata().getName() + " for commands " + Arrays.toString(commands));
            }
            latch.await(WaitConditions.scaled(1L), TimeUnit.MINUTES);
        }
        if (debugLogs) {
            LOGGER.info(captureOut.toString());
            LOGGER.info(captureErr.toString());
        }
        return new CommandOutputs(captureOut.toString(StandardCharsets.UTF_8), captureErr.toString(StandardCharsets.UTF_8));
    }

    public static class CommandOutputs {
        String stdOut;
        String stdErr;

        public CommandOutputs(String stdOut, String stdErr) {
            this.stdOut = stdOut;
            this.stdErr = stdErr;
        }

        public String getStdOut() {
            return this.stdOut;
        }

        public String getStdErr() {
            return this.stdErr;
        }

        public String toString() {
            return "CommandOutputs{stdOut='" + this.stdOut + "', stdErr='" + this.stdErr + "'}";
        }
    }
}

