/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases;

import io.debezium.testing.system.tools.OpenShiftUtils;
import io.debezium.testing.system.tools.WaitConditions;
import io.debezium.testing.system.tools.databases.DatabaseClient;
import io.debezium.testing.system.tools.databases.DatabaseController;
import io.debezium.testing.system.tools.databases.DatabaseExecListener;
import io.debezium.testing.system.tools.databases.DatabaseInitListener;
import io.debezium.testing.system.tools.databases.PortForwardableDatabaseController;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.PortForward;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorChannelable;
import io.fabric8.openshift.client.OpenShiftClient;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOcpDatabaseController<C extends DatabaseClient<?, ?>>
implements DatabaseController<C>,
PortForwardableDatabaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOcpDatabaseController.class);
    private static final String FORWARDED_HOST = "localhost";
    private static final int MAX_PORT_SEARCH_ATTEMPTS = 20;
    private static final int MIN_PORT = 32768;
    private static final int MAX_PORT = 60999;
    protected final OpenShiftClient ocp;
    protected final String project;
    protected final OpenShiftUtils ocpUtils;
    protected Deployment deployment;
    protected String name;
    protected List<Service> services;
    protected PortForward portForward;
    private int localPort;

    public AbstractOcpDatabaseController(Deployment deployment, List<Service> services, OpenShiftClient ocp) {
        this.deployment = deployment;
        this.name = deployment.getMetadata().getName();
        this.project = deployment.getMetadata().getNamespace();
        this.services = services;
        this.ocp = ocp;
        this.ocpUtils = new OpenShiftUtils(ocp);
    }

    private Service getService() {
        return (Service)((ServiceResource)((NonNamespaceOperation)this.ocp.services().inNamespace(this.project)).withName(this.deployment.getMetadata().getName())).get();
    }

    @Override
    public void reload() throws InterruptedException {
        if (!OpenShiftUtils.isRunningFromOcp()) {
            try {
                this.closeDatabasePortForwards();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        LOGGER.info("Removing all pods of '" + this.name + "' deployment in namespace '" + this.project + "'");
        this.ocpUtils.scaleDeploymentToZero(this.deployment);
        LOGGER.info("Restoring all pods of '" + this.name + "' deployment in namespace '" + this.project + "'");
        ((RollableScalableResource)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).withName(this.name)).scale(1);
        if (!OpenShiftUtils.isRunningFromOcp()) {
            this.forwardDatabasePorts();
        }
    }

    @Override
    public String getDatabaseHostname() {
        return this.getService().getMetadata().getName() + "." + this.project + ".svc.cluster.local";
    }

    @Override
    public int getDatabasePort() {
        return this.getOriginalDatabasePort();
    }

    @Override
    public String getPublicDatabaseHostname() {
        if (OpenShiftUtils.isRunningFromOcp()) {
            return this.getDatabaseHostname();
        }
        return FORWARDED_HOST;
    }

    @Override
    public int getPublicDatabasePort() {
        if (OpenShiftUtils.isRunningFromOcp()) {
            return this.getDatabasePort();
        }
        return this.localPort;
    }

    @Override
    public void initialize() throws InterruptedException {
        if (!OpenShiftUtils.isRunningFromOcp()) {
            this.forwardDatabasePorts();
        }
    }

    @Override
    public void forwardDatabasePorts() {
        if (this.portForward != null) {
            LOGGER.warn("Calling port forward when forward already on " + this.getOriginalDatabasePort() + "->" + this.localPort);
            return;
        }
        String serviceName = this.getService().getMetadata().getName();
        ServiceResource serviceResource = (ServiceResource)((NonNamespaceOperation)this.ocp.services().inNamespace(this.project)).withName(serviceName);
        int dbPort = this.getOriginalDatabasePort();
        try {
            this.localPort = this.getAvailablePort();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOGGER.info("Forwarding ports " + dbPort + "->" + this.localPort + " on service: " + serviceName);
        PortForward forward = (PortForward)serviceResource.portForward(dbPort, this.localPort);
        for (Throwable e : forward.getClientThrowables()) {
            LOGGER.warn("Client error when forwarding DB port " + this.deployment, e);
        }
        for (Throwable e : forward.getServerThrowables()) {
            LOGGER.warn("Server error when forwarding DB port" + this.deployment, e);
        }
        this.portForward = forward;
    }

    @Override
    public void closeDatabasePortForwards() throws IOException {
        LOGGER.info("Closing port forwards");
        this.portForward.close();
        this.portForward = null;
    }

    protected void executeInitCommand(Deployment deployment, String ... commands) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        String containerName = (String)deployment.getMetadata().getLabels().get("app");
        try (ExecWatch ignored = (ExecWatch)((Execable)this.prepareExec(deployment).usingListener((Object)new DatabaseInitListener(containerName, latch))).exec((Object[])commands);){
            LOGGER.info("Waiting until database is initialized");
            latch.await(WaitConditions.scaled(1L), TimeUnit.MINUTES);
        }
    }

    protected void executeCommand(Deployment deployment, String ... commands) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        try (ExecWatch ignored = (ExecWatch)((Execable)this.prepareExec(deployment).usingListener((Object)new DatabaseExecListener(deployment.getMetadata().getName(), latch))).exec((Object[])commands);){
            LOGGER.info("Waiting on " + deployment.getMetadata().getName() + " for commands " + Arrays.toString(commands));
            latch.await(WaitConditions.scaled(1L), TimeUnit.MINUTES);
        }
    }

    private TtyExecErrorChannelable<String, OutputStream, PipedInputStream, ExecWatch> prepareExec(Deployment deployment) {
        List<Pod> pods = this.ocpUtils.podsForDeployment(deployment);
        if (pods.size() > 1) {
            throw new IllegalArgumentException("Executing command on deployment scaled to more than 1");
        }
        Pod pod = pods.get(0);
        return (TtyExecErrorChannelable)((ContainerResource)this.getPodResource(pod).inContainer((Object)((String)pod.getMetadata().getLabels().get("app")))).writingError((Object)System.err);
    }

    private PodResource<Pod> getPodResource(Pod pod) {
        return (PodResource)((NonNamespaceOperation)this.ocp.pods().inNamespace(this.project)).withName(pod.getMetadata().getName());
    }

    private int getOriginalDatabasePort() {
        return this.getService().getSpec().getPorts().stream().filter(p -> p.getName().equals("db")).findAny().get().getPort();
    }

    private int getAvailablePort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }
}

