/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka;

import io.debezium.testing.system.tools.WaitConditions;
import io.debezium.testing.system.tools.kafka.KafkaController;
import io.debezium.testing.system.tools.kafka.docker.KafkaContainer;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerKafkaController
implements KafkaController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerKafkaController.class);
    private final KafkaContainer container;

    public DockerKafkaController(KafkaContainer container) {
        this.container = container;
    }

    public KafkaContainer getContainer() {
        return this.container;
    }

    @Override
    public String getPublicBootstrapAddress() {
        return this.container.getPublicBootstrapAddress();
    }

    @Override
    public String getBootstrapAddress() {
        return this.container.getBootstrapAddress();
    }

    @Override
    public boolean undeploy() {
        this.container.stop();
        return this.container.isRunning();
    }

    @Override
    public void waitForCluster() {
        Awaitility.await().atMost(WaitConditions.scaled(5L), TimeUnit.MINUTES).until(() -> ((KafkaContainer)this.container).isRunning());
    }
}

