/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka;

import io.debezium.testing.system.tools.AbstractOcpDeployer;
import io.debezium.testing.system.tools.kafka.OcpKafkaConnectController;
import io.debezium.testing.system.tools.kafka.StrimziOperatorController;
import io.debezium.testing.system.tools.kafka.builders.FabricKafkaConnectBuilder;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.client.OpenShiftClient;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.KafkaConnectList;
import io.strimzi.api.kafka.model.KafkaConnect;
import java.util.Optional;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpKafkaConnectDeployer
extends AbstractOcpDeployer<OcpKafkaConnectController> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpKafkaConnectDeployer.class);
    private final FabricKafkaConnectBuilder fabricBuilder;
    private final ConfigMap configMap;
    private final StrimziOperatorController operatorController;

    public OcpKafkaConnectDeployer(String project, FabricKafkaConnectBuilder fabricBuilder, ConfigMap configMap, StrimziOperatorController operatorController, OpenShiftClient ocp, OkHttpClient http) {
        super(project, ocp, http);
        this.fabricBuilder = fabricBuilder;
        this.configMap = configMap;
        this.operatorController = operatorController;
    }

    @Override
    public OcpKafkaConnectController deploy() throws InterruptedException {
        LOGGER.info("Deploying KafkaConnect");
        if (this.configMap != null) {
            this.deployConfigMap();
        }
        if (this.fabricBuilder.hasBuild()) {
            this.deployImageStream();
        }
        KafkaConnect kafkaConnect = this.fabricBuilder.build();
        kafkaConnect = (KafkaConnect)this.kafkaConnectOperation().createOrReplace((Object[])new KafkaConnect[]{kafkaConnect});
        OcpKafkaConnectController controller = new OcpKafkaConnectController(kafkaConnect, this.operatorController, this.ocp, this.http);
        controller.waitForCluster();
        return controller;
    }

    private void deployConfigMap() {
        ((NonNamespaceOperation)this.ocp.configMaps().inNamespace(this.project)).createOrReplace((Object[])new ConfigMap[]{this.configMap});
    }

    private void deployImageStream() {
        Optional<String> imageStream = this.fabricBuilder.imageStream();
        if (!imageStream.isPresent()) {
            throw new IllegalStateException("Image stream missing");
        }
        String[] image = this.fabricBuilder.imageStream().get().split(":", 2);
        ImageStream is = ((ImageStreamBuilder)((ImageStreamFluent.SpecNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(image[0])).endMetadata()).withNewSpec().withNewLookupPolicy(Boolean.valueOf(true))).endSpec()).build();
        ((NonNamespaceOperation)this.ocp.imageStreams().inNamespace(this.project)).createOrReplace((Object[])new ImageStream[]{is});
    }

    private NonNamespaceOperation<KafkaConnect, KafkaConnectList, Resource<KafkaConnect>> kafkaConnectOperation() {
        return (NonNamespaceOperation)Crds.kafkaConnectOperation((KubernetesClient)this.ocp).inNamespace(this.project);
    }
}

