/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases.oracle;

import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.databases.AbstractDockerSqlDatabaseController;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.OracleContainer;
import org.testcontainers.images.builder.Transferable;

public class DockerOracleController
extends AbstractDockerSqlDatabaseController<OracleContainer> {
    private static final String DB_INIT_SCRIPT_PATH = "/database-resources/oracle/inventory.sql";
    private static final String DB_INIT_SCRIPT_PATH_CONTAINER = "/home/oracle/inventory.sql";
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerOracleController.class);
    private final Path initScript;

    public DockerOracleController(OracleContainer container) {
        super(container);
        try {
            this.initScript = Paths.get(this.getClass().getResource(DB_INIT_SCRIPT_PATH).toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getDatabasePort() {
        return 1521;
    }

    @Override
    public void initialize() throws InterruptedException {
        try {
            ((OracleContainer)this.container).copyFileToContainer(Transferable.of((byte[])Files.readAllBytes(this.initScript)), DB_INIT_SCRIPT_PATH_CONTAINER);
            ((OracleContainer)this.container).execInContainer(new String[]{"sqlplus", "-S", ConfigProperties.DATABASE_ORACLE_USERNAME + "/" + ConfigProperties.DATABASE_ORACLE_PASSWORD + "@//localhost:1521/" + ConfigProperties.DATABASE_ORACLE_PDBNAME, "@/home/oracle/inventory.sql"});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

