/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.registry;

import io.apicurio.registry.operator.api.model.ApicurioRegistry;
import io.apicurio.registry.operator.api.model.ApicurioRegistryList;
import io.debezium.testing.system.tools.WaitConditions;
import io.debezium.testing.system.tools.registry.AbstractOcpApicurioController;
import io.debezium.testing.system.tools.registry.RegistryController;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpApicurioV1Controller
extends AbstractOcpApicurioController
implements RegistryController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpApicurioV1Controller.class);
    public static final String APICURIO_CRD_DESCRIPTOR = "/crd/v1beta1/apicurioregistries_crd.yaml";

    public OcpApicurioV1Controller(ApicurioRegistry registry, OpenShiftClient ocp, OkHttpClient http) {
        super(registry, ocp, http);
    }

    @Override
    protected NonNamespaceOperation<ApicurioRegistry, ApicurioRegistryList, Resource<ApicurioRegistry>> registryOperation() {
        CustomResourceDefinition crd = (CustomResourceDefinition)((Resource)this.ocp.apiextensions().v1beta1().customResourceDefinitions().load(OcpApicurioV1Controller.class.getResourceAsStream(APICURIO_CRD_DESCRIPTOR))).get();
        CustomResourceDefinitionContext context = CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)crd);
        return (NonNamespaceOperation)this.ocp.customResources(context, ApicurioRegistry.class, ApicurioRegistryList.class).inNamespace(this.project);
    }

    @Override
    public String getRegistryApiAddress() {
        return this.getRegistryAddress() + "/api";
    }

    @Override
    public String getPublicRegistryApiAddress() {
        return this.getPublicRegistryAddress() + "/api";
    }

    @Override
    public void waitForRegistry() throws InterruptedException {
        LOGGER.info("Waiting for deployments of registry '" + this.name + "'");
        Awaitility.await().atMost(WaitConditions.scaled(1L), TimeUnit.MINUTES).pollInterval(5L, TimeUnit.SECONDS).until(() -> !this.getRegistryDeployments(this.name).isEmpty());
        DeploymentConfig dc = this.getRegistryDeployments(this.name).get(0);
        ((DeployableScalableResource)((NonNamespaceOperation)this.ocp.deploymentConfigs().inNamespace(this.project)).withName(dc.getMetadata().getName())).waitUntilCondition(WaitConditions::deploymentAvailableCondition, WaitConditions.scaled(5L), TimeUnit.MINUTES);
        this.registry = (ApicurioRegistry)((Resource)this.registryOperation().withName(this.name)).get();
    }

    private List<DeploymentConfig> getRegistryDeployments(String name) {
        return ((DeploymentConfigList)((FilterWatchListDeletable)((NonNamespaceOperation)this.ocp.deploymentConfigs().inNamespace(this.project)).withLabel("app", name)).list()).getItems();
    }
}

