/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka;

import io.debezium.testing.system.tools.AbstractOcpDeployer;
import io.debezium.testing.system.tools.Deployer;
import io.debezium.testing.system.tools.YAML;
import io.debezium.testing.system.tools.kafka.OcpKafkaController;
import io.debezium.testing.system.tools.kafka.StrimziOperatorController;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.client.OpenShiftClient;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.KafkaList;
import io.strimzi.api.kafka.model.Kafka;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OcpKafkaDeployer
extends AbstractOcpDeployer<OcpKafkaController> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpKafkaDeployer.class);
    private final String yamlPath;
    private final StrimziOperatorController operatorController;

    private OcpKafkaDeployer(String project, String yamlPath, StrimziOperatorController operatorController, OpenShiftClient ocp, OkHttpClient http) {
        super(project, ocp, http);
        this.yamlPath = yamlPath;
        this.operatorController = operatorController != null ? operatorController : StrimziOperatorController.forProject(project, ocp);
    }

    @Override
    public OcpKafkaController deploy() throws InterruptedException {
        LOGGER.info("Deploying Kafka from " + this.yamlPath);
        Kafka kafka = (Kafka)this.kafkaOperation().createOrReplace((Object[])new Kafka[]{YAML.fromResource(this.yamlPath, Kafka.class)});
        OcpKafkaController controller = new OcpKafkaController(kafka, this.operatorController, this.ocp);
        controller.waitForCluster();
        return controller;
    }

    private NonNamespaceOperation<Kafka, KafkaList, Resource<Kafka>> kafkaOperation() {
        return (NonNamespaceOperation)Crds.kafkaOperation((KubernetesClient)this.ocp).inNamespace(this.project);
    }

    public static class Builder
    implements Deployer.Builder<Builder, OcpKafkaDeployer> {
        private String project;
        private String yamlPath;
        private OpenShiftClient ocpClient;
        private OkHttpClient httpClient;
        private StrimziOperatorController operatorController;

        public Builder withProject(String project) {
            this.project = project;
            return this;
        }

        public Builder withOcpClient(OpenShiftClient ocpClient) {
            this.ocpClient = ocpClient;
            return this;
        }

        public Builder withHttpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder withYamlPath(String yamlPath) {
            this.yamlPath = yamlPath;
            return this;
        }

        public Builder withOperatorController(StrimziOperatorController operatorController) {
            this.operatorController = operatorController;
            return this;
        }

        @Override
        public OcpKafkaDeployer build() {
            return new OcpKafkaDeployer(this.project, this.yamlPath, this.operatorController, this.ocpClient, this.httpClient);
        }
    }
}

