/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms.scripting;

import io.debezium.transforms.scripting.Jsr223Engine;
import io.debezium.transforms.scripting.RecordHeader;
import java.util.ArrayList;
import java.util.Map;
import javax.script.Bindings;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.Header;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyObject;

public class GraalJsEngine
extends Jsr223Engine {
    @Override
    protected void configureEngine() {
        Bindings bindings = this.engine.getBindings(100);
        bindings.put("polyglot.js.allowHostAccess", (Object)true);
    }

    @Override
    protected Object key(ConnectRecord<?> record) {
        return this.asProxyObject((Struct)record.key());
    }

    @Override
    protected Object value(ConnectRecord<?> record) {
        return this.asProxyObject((Struct)record.value());
    }

    @Override
    protected Object headers(ConnectRecord<?> record) {
        return this.asProxyObject(this.doHeaders(record));
    }

    @Override
    protected RecordHeader header(Header header) {
        if (header.value() instanceof Struct) {
            return new RecordHeader(header.schema(), this.asProxyObject((Struct)header.value()));
        }
        return super.header(header);
    }

    private ProxyObject asProxyObject(final Struct struct) {
        return new ProxyObject(){

            public void putMember(String key, Value value) {
                throw new UnsupportedOperationException("Record attributes must not be modified from within this transformation");
            }

            public boolean hasMember(String key) {
                return struct.schema().field(key) != null;
            }

            public Object getMemberKeys() {
                ArrayList<String> fieldNames = new ArrayList<String>(struct.schema().fields().size());
                for (Field field : struct.schema().fields()) {
                    fieldNames.add(field.name());
                }
                return fieldNames;
            }

            public Object getMember(String key) {
                Object value = struct.get(key);
                if (value instanceof Struct) {
                    return GraalJsEngine.this.asProxyObject((Struct)value);
                }
                return value;
            }
        };
    }

    private ProxyObject asProxyObject(final Map<String, ?> map) {
        return new ProxyObject(){

            public void putMember(String key, Value value) {
                throw new UnsupportedOperationException("Record attributes must not be modified from within this transformation");
            }

            public boolean hasMember(String key) {
                return map.containsKey(key);
            }

            public Object getMemberKeys() {
                return map.keySet();
            }

            public Object getMember(String key) {
                return map.get(key);
            }
        };
    }
}

