/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.schemagenerator;

import io.debezium.config.Field;
import io.debezium.metadata.ConnectorMetadata;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.schemagenerator.schema.Schema;
import io.debezium.storage.kafka.history.KafkaSchemaHistory;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.kafka.common.config.ConfigDef;
import org.eclipse.microprofile.openapi.models.media.Schema;

public class JsonSchemaCreatorService {
    private final String connectorBaseName;
    private final String connectorName;
    private final ConnectorMetadata connectorMetadata;
    private final Schema.FieldFilter fieldFilter;
    private final List<String> errors = new ArrayList<String>();

    public JsonSchemaCreatorService(ConnectorMetadata connectorMetadata, Schema.FieldFilter fieldFilter) {
        this.connectorBaseName = connectorMetadata.getConnectorDescriptor().getId();
        this.connectorName = this.connectorBaseName + "-" + connectorMetadata.getConnectorDescriptor().getVersion();
        this.connectorMetadata = connectorMetadata;
        this.fieldFilter = fieldFilter;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    private Field checkField(Field field) {
        String propertyName = field.name();
        if (propertyName.contains("whitelist") || propertyName.contains("blacklist") || propertyName.startsWith("internal.")) {
            return null;
        }
        if (!this.fieldFilter.include(field)) {
            this.errors.add("[INFO] Skipped property \"" + propertyName + "\" for connector \"" + this.connectorName + "\" because it was not in the include list file.");
            return null;
        }
        if (null == field.group()) {
            this.errors.add("[WARN] Missing GroupEntry for property \"" + propertyName + "\" for connector \"" + this.connectorName + "\".");
            return field.withGroup(Field.createGroupEntry((Field.Group)Field.Group.ADVANCED));
        }
        return field;
    }

    private static JsonSchemaType toJsonSchemaType(ConfigDef.Type type) {
        switch (type) {
            case BOOLEAN: {
                return new JsonSchemaType(Schema.SchemaType.BOOLEAN);
            }
            case CLASS: {
                return new JsonSchemaType(Schema.SchemaType.STRING, "class");
            }
            case DOUBLE: {
                return new JsonSchemaType(Schema.SchemaType.NUMBER, "double");
            }
            case INT: 
            case SHORT: {
                return new JsonSchemaType(Schema.SchemaType.INTEGER, "int32");
            }
            case LIST: {
                return new JsonSchemaType(Schema.SchemaType.STRING, "list,regex");
            }
            case LONG: {
                return new JsonSchemaType(Schema.SchemaType.INTEGER, "int64");
            }
            case PASSWORD: {
                return new JsonSchemaType(Schema.SchemaType.STRING, "password");
            }
            case STRING: {
                return new JsonSchemaType(Schema.SchemaType.STRING);
            }
        }
        throw new IllegalArgumentException("Unsupported property type: " + type);
    }

    public Schema buildConnectorSchema() {
        SchemaImpl schema = new SchemaImpl(this.connectorName);
        String connectorVersion = this.connectorMetadata.getConnectorDescriptor().getVersion();
        schema.setTitle(this.connectorMetadata.getConnectorDescriptor().getDisplayName());
        schema.setType(Schema.SchemaType.OBJECT);
        schema.addExtension("connector-id", (Object)this.connectorBaseName);
        schema.addExtension("version", (Object)connectorVersion);
        schema.addExtension("className", (Object)this.connectorMetadata.getConnectorDescriptor().getClassName());
        HashMap orderedPropertiesByCategory = new HashMap();
        Arrays.stream(Field.Group.values()).forEach(category -> orderedPropertiesByCategory.put(category, new TreeMap()));
        this.connectorMetadata.getConnectorFields().forEach(arg_0 -> this.lambda$buildConnectorSchema$1((Schema)schema, orderedPropertiesByCategory, arg_0));
        Arrays.stream(Field.Group.values()).forEach(arg_0 -> JsonSchemaCreatorService.lambda$buildConnectorSchema$3(orderedPropertiesByCategory, (Schema)schema, arg_0));
        schema.additionalPropertiesBoolean(Boolean.valueOf(true));
        return schema;
    }

    private void processField(Schema schema, Map<Field.Group, SortedMap<Integer, SchemaImpl>> orderedPropertiesByCategory, Field field) {
        String propertyName = field.name();
        Field checkedField = this.checkField(field);
        if (null != checkedField) {
            SchemaImpl propertySchema = new SchemaImpl(propertyName);
            Set allowedValues = checkedField.allowedValues();
            if (null != allowedValues && !allowedValues.isEmpty()) {
                propertySchema.enumeration(new ArrayList(allowedValues));
            }
            if (checkedField.isRequired()) {
                propertySchema.nullable(Boolean.valueOf(false));
                schema.addRequired(propertyName);
            }
            propertySchema.description(checkedField.description());
            propertySchema.defaultValue(checkedField.defaultValue());
            JsonSchemaType jsonSchemaType = JsonSchemaCreatorService.toJsonSchemaType(checkedField.type());
            propertySchema.type(jsonSchemaType.schemaType);
            if (null != jsonSchemaType.format) {
                propertySchema.format(jsonSchemaType.format);
            }
            propertySchema.title(checkedField.displayName());
            HashMap<String, String> extensions = new HashMap<String, String>();
            extensions.put("name", checkedField.name());
            Field.GroupEntry groupEntry = checkedField.group();
            extensions.put("category", groupEntry.getGroup().name());
            propertySchema.extensions(extensions);
            SortedMap<Integer, SchemaImpl> groupProperties = orderedPropertiesByCategory.get(groupEntry.getGroup());
            if (groupProperties.containsKey(groupEntry.getPositionInGroup())) {
                this.errors.add("[ERROR] Position in group \"" + groupEntry.getGroup().name() + "\" for property \"" + propertyName + "\" is used more than once for connector \"" + this.connectorName + "\".");
            } else {
                groupProperties.put(groupEntry.getPositionInGroup(), propertySchema);
            }
            if (propertyName.equals(HistorizedRelationalDatabaseConnectorConfig.SCHEMA_HISTORY.name())) {
                KafkaSchemaHistory.ALL_FIELDS.forEach(historyField -> this.processField(schema, orderedPropertiesByCategory, (Field)historyField));
            }
        }
    }

    private static /* synthetic */ void lambda$buildConnectorSchema$3(Map orderedPropertiesByCategory, Schema schema, Field.Group group) {
        ((SortedMap)orderedPropertiesByCategory.get(group)).forEach((position, propertySchema) -> schema.addProperty(propertySchema.getName(), (Schema)propertySchema));
    }

    private /* synthetic */ void lambda$buildConnectorSchema$1(Schema schema, Map orderedPropertiesByCategory, Field field) {
        this.processField(schema, orderedPropertiesByCategory, field);
    }

    public static class JsonSchemaType {
        public final Schema.SchemaType schemaType;
        public final String format;

        public JsonSchemaType(Schema.SchemaType schemaType, String format) {
            this.schemaType = schemaType;
            this.format = format;
        }

        public JsonSchemaType(Schema.SchemaType schemaType) {
            this.schemaType = schemaType;
            this.format = null;
        }
    }
}

