/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.quarkus.deployment;

import io.debezium.DebeziumException;
import io.debezium.outbox.quarkus.deployment.DebeziumOutboxCommonConfig;
import io.debezium.outbox.quarkus.deployment.OutboxEventEntityBuildItem;
import io.debezium.outbox.quarkus.internal.JsonNodeAttributeConverter;
import java.time.Instant;
import java.util.UUID;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmBasicAttributeType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmColumnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmGeneratorSpecificationType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmIdentifierGeneratorDefinitionType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmRootEntityType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmSimpleIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboxEventHbmWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutboxEventHbmWriter.class);
    private static final String JACKSON_JSONNODE = "com.fasterxml.jackson.databind.JsonNode";

    static JaxbHbmHibernateMapping write(DebeziumOutboxCommonConfig config, OutboxEventEntityBuildItem outboxEventEntityBuildItem) {
        JaxbHbmHibernateMapping mapping = new JaxbHbmHibernateMapping();
        JaxbHbmRootEntityType entityType = new JaxbHbmRootEntityType();
        entityType.setEntityName("io.debezium.outbox.quarkus.internal.OutboxEvent");
        entityType.setTable(config.tableName());
        mapping.getClazz().add(entityType);
        JaxbHbmIdentifierGeneratorDefinitionType generatorType = new JaxbHbmIdentifierGeneratorDefinitionType();
        generatorType.setName("uuid2");
        generatorType.setClazz("uuid2");
        mapping.getIdentifierGenerator().add(generatorType);
        entityType.setId(OutboxEventHbmWriter.createIdAttribute(config));
        entityType.getAttributes().add(OutboxEventHbmWriter.createAggregateTypeAttribute(config));
        entityType.getAttributes().add(OutboxEventHbmWriter.createAggregateIdAttribute(config, outboxEventEntityBuildItem));
        entityType.getAttributes().add(OutboxEventHbmWriter.createTypeAttribute(config));
        entityType.getAttributes().add(OutboxEventHbmWriter.createTimestampAttribute(config));
        entityType.getAttributes().add(OutboxEventHbmWriter.createPayloadAttribute(config, outboxEventEntityBuildItem));
        if (config.tracingEnabled()) {
            entityType.getAttributes().add(OutboxEventHbmWriter.createTracingSpanAttribute(config));
        }
        if (config.additionalFields().isPresent()) {
            String[] fields = config.additionalFields().get().split(",");
            for (int fieldIndex = 0; fieldIndex < fields.length; ++fieldIndex) {
                String[] parts = fields[fieldIndex].split(":");
                if (parts.length < 2) {
                    throw new DebeziumException("Expected a column and data type for additional field #" + fieldIndex);
                }
                String fieldName = parts[0];
                String fieldDataType = parts[1];
                String sqlType = null;
                if (parts.length >= 3) {
                    sqlType = parts[2];
                }
                String fieldConverter = null;
                if (parts.length == 4) {
                    fieldConverter = parts[3];
                }
                LOGGER.info("Binding additional field '{}' as '{}' with {} converter.", new Object[]{fieldName, fieldDataType, fieldConverter == null ? "no" : "a"});
                entityType.getAttributes().add(OutboxEventHbmWriter.createAdditionalField(fieldName, fieldDataType, sqlType, fieldConverter));
            }
        }
        return mapping;
    }

    private static JaxbHbmSimpleIdType createIdAttribute(DebeziumOutboxCommonConfig config) {
        JaxbHbmSimpleIdType attribute = new JaxbHbmSimpleIdType();
        attribute.setName("id");
        attribute.setTypeAttribute(UUID.class.getName());
        JaxbHbmColumnType column = new JaxbHbmColumnType();
        column.setName(config.id().name());
        config.id().columnDefinition().ifPresent(arg_0 -> ((JaxbHbmColumnType)column).setSqlType(arg_0));
        attribute.getColumn().add(column);
        JaxbHbmGeneratorSpecificationType generator = new JaxbHbmGeneratorSpecificationType();
        generator.setClazz("uuid2");
        attribute.setGenerator(generator);
        return attribute;
    }

    private static JaxbHbmBasicAttributeType createAggregateTypeAttribute(DebeziumOutboxCommonConfig config) {
        JaxbHbmBasicAttributeType attribute = new JaxbHbmBasicAttributeType();
        attribute.setName("aggregateType");
        attribute.setNotNull(Boolean.valueOf(true));
        if (config.aggregateType().converter().isPresent()) {
            attribute.setTypeAttribute("converted::" + config.aggregateType().converter().get());
        } else {
            attribute.setTypeAttribute("string");
        }
        JaxbHbmColumnType column = new JaxbHbmColumnType();
        column.setName(config.aggregateType().name());
        config.aggregateType().columnDefinition().ifPresent(arg_0 -> ((JaxbHbmColumnType)column).setSqlType(arg_0));
        attribute.getColumnOrFormula().add(column);
        return attribute;
    }

    private static JaxbHbmBasicAttributeType createAggregateIdAttribute(DebeziumOutboxCommonConfig config, OutboxEventEntityBuildItem outboxEventEntityBuildItem) {
        JaxbHbmBasicAttributeType attribute = new JaxbHbmBasicAttributeType();
        attribute.setName("aggregateId");
        attribute.setNotNull(Boolean.valueOf(true));
        if (config.aggregateId().converter().isPresent()) {
            attribute.setTypeAttribute("converted::" + config.aggregateId().converter().get());
        } else {
            attribute.setTypeAttribute(outboxEventEntityBuildItem.getAggregateIdType().name().toString());
        }
        JaxbHbmColumnType column = new JaxbHbmColumnType();
        column.setName(config.aggregateId().name());
        config.aggregateId().columnDefinition().ifPresent(arg_0 -> ((JaxbHbmColumnType)column).setSqlType(arg_0));
        attribute.getColumnOrFormula().add(column);
        return attribute;
    }

    private static JaxbHbmBasicAttributeType createTypeAttribute(DebeziumOutboxCommonConfig config) {
        JaxbHbmBasicAttributeType attribute = new JaxbHbmBasicAttributeType();
        attribute.setName("type");
        attribute.setNotNull(Boolean.valueOf(true));
        if (config.type().converter().isPresent()) {
            attribute.setTypeAttribute("converted::" + config.type().converter().get());
        } else {
            attribute.setTypeAttribute("string");
        }
        JaxbHbmColumnType column = new JaxbHbmColumnType();
        column.setName(config.type().name());
        config.type().columnDefinition().ifPresent(arg_0 -> ((JaxbHbmColumnType)column).setSqlType(arg_0));
        attribute.getColumnOrFormula().add(column);
        return attribute;
    }

    private static JaxbHbmBasicAttributeType createTimestampAttribute(DebeziumOutboxCommonConfig config) {
        JaxbHbmBasicAttributeType attribute = new JaxbHbmBasicAttributeType();
        attribute.setName("timestamp");
        attribute.setNotNull(Boolean.valueOf(true));
        if (config.timestamp().converter().isPresent()) {
            attribute.setTypeAttribute("converted::" + config.timestamp().converter().get());
        } else {
            attribute.setTypeAttribute(Instant.class.getName());
        }
        JaxbHbmColumnType column = new JaxbHbmColumnType();
        column.setName(config.timestamp().name());
        config.timestamp().columnDefinition().ifPresent(arg_0 -> ((JaxbHbmColumnType)column).setSqlType(arg_0));
        attribute.getColumnOrFormula().add(column);
        return attribute;
    }

    private static JaxbHbmBasicAttributeType createPayloadAttribute(DebeziumOutboxCommonConfig config, OutboxEventEntityBuildItem outboxEventEntityBuildItem) {
        boolean isJacksonJsonNode = OutboxEventHbmWriter.isPayloadJacksonJsonNode(outboxEventEntityBuildItem);
        JaxbHbmBasicAttributeType attribute = new JaxbHbmBasicAttributeType();
        attribute.setName("payload");
        attribute.setNotNull(Boolean.valueOf(false));
        if (config.payload().type().isPresent()) {
            LOGGER.info("Using payload type: {}", (Object)config.payload().type().get());
            attribute.setTypeAttribute(config.payload().type().get());
        } else if (config.payload().converter().isPresent()) {
            LOGGER.info("Using payload attribute converter: {}", (Object)config.payload().converter().get());
            attribute.setTypeAttribute("converted::" + config.payload().converter().get());
        } else if (isJacksonJsonNode) {
            LOGGER.info("Using payload attribute converter: {}", (Object)JsonNodeAttributeConverter.class.getName());
            attribute.setTypeAttribute("converted::" + JsonNodeAttributeConverter.class.getName());
        } else {
            String resolvedTypeName = outboxEventEntityBuildItem.getPayloadType().name().toString();
            LOGGER.info("Using payload resolved type: {}", (Object)resolvedTypeName);
            attribute.setTypeAttribute(resolvedTypeName);
        }
        JaxbHbmColumnType column = new JaxbHbmColumnType();
        column.setName(config.payload().name());
        if (config.payload().columnDefinition().isPresent()) {
            column.setSqlType(config.payload().columnDefinition().get());
        } else if (isJacksonJsonNode) {
            column.setSqlType("varchar(8000)");
        }
        attribute.getColumnOrFormula().add(column);
        return attribute;
    }

    private static JaxbHbmBasicAttributeType createTracingSpanAttribute(DebeziumOutboxCommonConfig config) {
        JaxbHbmBasicAttributeType attribute = new JaxbHbmBasicAttributeType();
        attribute.setName("tracingspancontext");
        attribute.setNotNull(Boolean.valueOf(false));
        attribute.setTypeAttribute("string");
        JaxbHbmColumnType column = new JaxbHbmColumnType();
        column.setName(config.tracingSpan().name());
        column.setLength(Integer.valueOf(256));
        config.tracingSpan().columnDefinition().ifPresent(arg_0 -> ((JaxbHbmColumnType)column).setSqlType(arg_0));
        attribute.getColumnOrFormula().add(column);
        return attribute;
    }

    private static JaxbHbmBasicAttributeType createAdditionalField(String name, String dataType, String sqlType, String converter) {
        JaxbHbmBasicAttributeType attribute = new JaxbHbmBasicAttributeType();
        attribute.setName(name);
        if (converter != null) {
            attribute.setTypeAttribute("converted::" + converter);
        } else {
            attribute.setTypeAttribute(dataType);
        }
        JaxbHbmColumnType column = new JaxbHbmColumnType();
        column.setName(name);
        if (sqlType != null) {
            column.setSqlType(sqlType);
        }
        attribute.getColumnOrFormula().add(column);
        return attribute;
    }

    private static boolean isPayloadJacksonJsonNode(OutboxEventEntityBuildItem outboxEventEntityBuildItem) {
        return outboxEventEntityBuildItem.getPayloadType().name().toString().equals(JACKSON_JSONNODE);
    }
}

