/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.openlineage;

import io.debezium.openlineage.Module;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.header.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record ConnectorContext(String connectorLogicalName, String connectorName, String taskId, String version, Map<String, String> config) {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectorContext.class);
    private static final String KEY_FORMAT = "%s:%s";

    public static ConnectorContext from(Map<String, String> configuration, String connectorTypeName) {
        return new ConnectorContext(configuration.get("topic.prefix"), connectorTypeName, configuration.getOrDefault("task.id", "0"), Module.version(), configuration);
    }

    public static ConnectorContext from(Headers headers) {
        Map<String, Object> contextHeaders = StreamSupport.stream(headers.spliterator(), false).filter(header -> header.key().startsWith("__debezium.context.")).collect(Collectors.toMap(Header::key, Header::value));
        if (contextHeaders.isEmpty()) {
            LOGGER.warn("OpenLineage SMT is not able to get required {} headers.", (Object)"__debezium.");
        }
        return new ConnectorContext((String)contextHeaders.get("__debezium.context.connectorLogicalName"), (String)contextHeaders.get("__debezium.context.connectorName"), (String)contextHeaders.get("__debezium.context.taskId"), null, null);
    }

    public String toEmitterKey() {
        return String.format(KEY_FORMAT, this.connectorLogicalName, this.taskId);
    }
}

