/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded;

import io.debezium.config.Field;
import io.debezium.engine.spi.OffsetCommitPolicy;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import java.time.Duration;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.storage.FileOffsetBackingStore;
import org.apache.kafka.connect.storage.KafkaOffsetBackingStore;

public interface EmbeddedEngineConfig {
    public static final Field ENGINE_NAME = Field.create((String)"name").withDescription("Unique name for this connector instance.").required();
    public static final Field CONNECTOR_CLASS = Field.create((String)"connector.class").withDescription("The Java class for the connector").required();
    public static final Field.Set CONNECTOR_FIELDS = Field.setOf((Field[])new Field[]{ENGINE_NAME, CONNECTOR_CLASS});
    public static final Field OFFSET_STORAGE = Field.create((String)"offset.storage").withDescription("The Java class that implements the `OffsetBackingStore` interface, used to periodically store offsets so that, upon restart, the connector can resume where it last left off.").withDefault(FileOffsetBackingStore.class.getName());
    public static final Field OFFSET_STORAGE_FILE_FILENAME = Field.create((String)"offset.storage.file.filename").withDescription("The file where offsets are to be stored. Required when 'offset.storage' is set to the " + FileOffsetBackingStore.class.getName() + " class.").withDefault("");
    public static final Field OFFSET_STORAGE_KAFKA_TOPIC = Field.create((String)"offset.storage.topic").withDescription("The name of the Kafka topic where offsets are to be stored. Required with other properties when 'offset.storage' is set to the " + KafkaOffsetBackingStore.class.getName() + " class.").withDefault("");
    public static final Field OFFSET_STORAGE_KAFKA_PARTITIONS = Field.create((String)"offset.storage.partitions").withType(ConfigDef.Type.INT).withDescription("The number of partitions used when creating the offset storage topic. Required with other properties when 'offset.storage' is set to the " + KafkaOffsetBackingStore.class.getName() + " class.");
    public static final Field OFFSET_STORAGE_KAFKA_REPLICATION_FACTOR = Field.create((String)"offset.storage.replication.factor").withType(ConfigDef.Type.SHORT).withDescription("Replication factor used when creating the offset storage topic. Required with other properties when 'offset.storage' is set to the " + KafkaOffsetBackingStore.class.getName() + " class.");
    public static final Field OFFSET_FLUSH_INTERVAL_MS = Field.create((String)"offset.flush.interval.ms").withDescription("Interval at which to try committing offsets, given in milliseconds. Defaults to 1 minute (60,000 ms).").withDefault(60000L).withValidation(new Field.Validator[]{Field::isNonNegativeInteger});
    public static final Field OFFSET_COMMIT_TIMEOUT_MS = Field.create((String)"offset.flush.timeout.ms").withDescription("Time to wait for records to flush and partition offset data to be committed to offset storage before cancelling the process and restoring the offset data to be committed in a future attempt, given in milliseconds. Defaults to 5 seconds (5000 ms).").withDefault(5000L).withValidation(new Field.Validator[]{Field::isPositiveInteger});
    public static final Field OFFSET_COMMIT_POLICY = Field.create((String)"offset.commit.policy").withDescription("The fully-qualified class name of the commit policy type. This class must implement the interface " + OffsetCommitPolicy.class.getName() + ". The default is a periodic commit policy based upon time intervals.").withDefault(OffsetCommitPolicy.PeriodicCommitOffsetPolicy.class.getName()).withValidation(new Field.Validator[]{Field::isClassName});
    public static final Field PREDICATES = Field.create((String)"predicates").withDisplayName("List of prefixes defining predicates.").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("Optional list of predicates that can be assigned to transformations. The predicates are defined using '<predicate.prefix>.type' config option and configured using options '<predicate.prefix>.<option>'");
    public static final Field TRANSFORMS = Field.create((String)"transforms").withDisplayName("List of prefixes defining transformations.").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("Optional list of single message transformations applied on the messages. The transforms are defined using '<transform.prefix>.type' config option and configured using options '<transform.prefix>.<option>'");
    public static final Field ERRORS_RETRY_DELAY_INITIAL_MS = Field.create((String)"errors.retry.delay.initial.ms").withDisplayName("Initial delay for retries").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(300).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription("Initial delay (in ms) for retries when encountering connection errors. This value will be doubled upon every retry but won't exceed 'errors.retry.delay.max.ms'.");
    public static final Field ERRORS_RETRY_DELAY_MAX_MS = Field.create((String)"errors.retry.delay.max.ms").withDisplayName("Max delay between retries").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(10000).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription("Max delay (in ms) between retries when encountering connection errors.");
    public static final Field WAIT_FOR_COMPLETION_BEFORE_INTERRUPT_MS = Field.create((String)"debezium.embedded.shutdown.pause.before.interrupt.ms").withDisplayName("Time to wait to engine completion before interrupt").withType(ConfigDef.Type.LONG).withDefault(Duration.ofMinutes(5L).toMillis()).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription(String.format("How long we wait before forcefully stopping the connector thread when shutting down. Must be bigger than the time it takes two polling loops to finish ({} ms)", ChangeEventSourceCoordinator.SHUTDOWN_WAIT_TIMEOUT.toMillis() * 2L));
    public static final int DEFAULT_ERROR_MAX_RETRIES = -1;
    public static final Field ERRORS_MAX_RETRIES = Field.create((String)"errors.max.retries").withDisplayName("The maximum number of retries").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(-1).withValidation(new Field.Validator[]{Field::isInteger}).withDescription("The maximum number of retries on connection errors before failing (-1 = no limit, 0 = disabled, > 0 = num of retries).");
    public static final Field.Set ALL_FIELDS = CONNECTOR_FIELDS.with(new Field[]{OFFSET_STORAGE, OFFSET_STORAGE_FILE_FILENAME, OFFSET_FLUSH_INTERVAL_MS, OFFSET_COMMIT_TIMEOUT_MS, ERRORS_MAX_RETRIES, ERRORS_RETRY_DELAY_INITIAL_MS, ERRORS_RETRY_DELAY_MAX_MS});
}

