/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded.async;

import io.debezium.embedded.async.AbstractRecordProcessor;
import io.debezium.embedded.async.ProcessingCallables;
import io.debezium.engine.DebeziumEngine;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelSmtConsumerProcessor
extends AbstractRecordProcessor<SourceRecord> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParallelSmtConsumerProcessor.class);
    final DebeziumEngine.RecordCommitter committer;
    final Consumer<SourceRecord> consumer;

    ParallelSmtConsumerProcessor(DebeziumEngine.RecordCommitter committer, Consumer<SourceRecord> consumer) {
        this.committer = committer;
        this.consumer = consumer;
    }

    @Override
    public void processRecords(List<SourceRecord> records) throws Exception {
        LOGGER.debug("Thread {} is submitting {} records for processing.", (Object)Thread.currentThread().getName(), (Object)records.size());
        Future[] recordFutures = new Future[records.size()];
        Iterator<SourceRecord> recordsIterator = records.iterator();
        int i = 0;
        while (recordsIterator.hasNext()) {
            recordFutures[i] = this.recordService.submit(new ProcessingCallables.TransformRecord(recordsIterator.next(), this.transformations));
            ++i;
        }
        LOGGER.trace("Calling user consumer.");
        recordsIterator = records.iterator();
        i = 0;
        while (recordsIterator.hasNext()) {
            this.consumer.accept((SourceRecord)recordFutures[i].get());
            this.committer.markProcessed((Object)recordsIterator.next());
            ++i;
        }
        LOGGER.trace("Marking batch as finished.");
        this.committer.markBatchFinished();
    }
}

