/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.spatial;

import io.debezium.DebeziumException;
import io.debezium.spatial.GeometryBytes;
import io.debezium.spatial.GeometryTraverser;
import io.debezium.spatial.GeometryUtil;
import io.debezium.spatial.GeometryVisitor;
import java.nio.ByteBuffer;
import java.util.Arrays;

class GeometryCoordinateSwapper {
    static final int[] DEFAULT_SWAP_SRIDS = new int[]{4326, 3857, 4269};

    GeometryCoordinateSwapper() {
    }

    public static GeometryBytes swap(GeometryBytes geometry) {
        return GeometryCoordinateSwapper.swap(geometry, DEFAULT_SWAP_SRIDS);
    }

    public static GeometryBytes swap(GeometryBytes geometry, int ... srids) {
        Integer srid = geometry.getSrid();
        if (srid == null || !GeometryCoordinateSwapper.needsSwapping(srid, srids)) {
            return geometry;
        }
        return GeometryCoordinateSwapper.swapNoCheck(geometry);
    }

    public static GeometryBytes swapNoCheck(GeometryBytes geometry) {
        if (geometry.getSrid() == null) {
            return geometry;
        }
        byte[] swapped = GeometryCoordinateSwapper.swapCoordinates(geometry.getBytes());
        return new GeometryBytes(swapped, geometry.getSrid());
    }

    private static boolean needsSwapping(int srid, int[] allowedSrids) {
        return Arrays.stream(allowedSrids).anyMatch(n -> n == srid);
    }

    private static byte[] swapCoordinates(byte[] wkb) {
        try {
            ByteBuffer input = ByteBuffer.wrap(wkb);
            byte byteOrder = input.get();
            input.order(GeometryUtil.getByteOrder(byteOrder));
            ByteBuffer output = ByteBuffer.allocate(wkb.length);
            output.order(input.order());
            output.put(byteOrder);
            GeometryTraverser.traverse(input, new SwapVisitor(output));
            return Arrays.copyOf(output.array(), output.position());
        }
        catch (Exception e) {
            throw new DebeziumException("Failed to swap EWKB/WKB coordinates", (Throwable)e);
        }
    }

    private record SwapVisitor(ByteBuffer output) implements GeometryVisitor
    {
        @Override
        public boolean enterGeometry(int wkbType, boolean hasZ, boolean hasM, int stride) {
            this.output.putInt(wkbType);
            return true;
        }

        @Override
        public boolean enterCollectionGeometry(byte byteOrder) {
            this.output.put(byteOrder);
            return true;
        }

        @Override
        public boolean enterSubGeometry(byte byteOrder, int wkbType) {
            this.output.put(byteOrder);
            this.output.putInt(wkbType);
            return true;
        }

        @Override
        public void visitSrid(int srid) {
            this.output.putInt(srid);
        }

        @Override
        public void visitCoordinate(double[] ordinates) {
            this.output.putDouble(ordinates[1]);
            this.output.putDouble(ordinates[0]);
            for (int i = 2; i < ordinates.length; ++i) {
                this.output.putDouble(ordinates[i]);
            }
        }

        @Override
        public void startLineString(int pointCount) {
            this.output.putInt(pointCount);
        }

        @Override
        public void startPolygon(int ringCount) {
            this.output.putInt(ringCount);
        }

        @Override
        public void startRing(int ringIndex, int pointCount) {
            this.output.putInt(pointCount);
        }

        @Override
        public void startMultiPoint(int pointCount) {
            this.output.putInt(pointCount);
        }

        @Override
        public void startMultiLineString(int lineStringCount) {
            this.output.putInt(lineStringCount);
        }

        @Override
        public void startMultiPolygon(int polygonCount) {
            this.output.putInt(polygonCount);
        }

        @Override
        public void startGeometryCollection(int geometryCount) {
            this.output.putInt(geometryCount);
        }
    }
}

