/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.spatial;

import io.debezium.spatial.GeometryCoordinateSwapper;
import io.debezium.spatial.GeometryEndiannessConverter;
import io.debezium.spatial.GeometryFormatConverter;
import io.debezium.spatial.GeometryTraverser;
import io.debezium.spatial.GeometryUtil;
import io.debezium.spatial.GeometryVisitor;
import io.debezium.util.HexConverter;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

public class GeometryBytes {
    private final byte[] wkb;
    private final Integer srid;

    public GeometryBytes(byte[] wkb, Integer srid) {
        this.wkb = wkb;
        this.srid = srid;
    }

    public GeometryBytes(byte[] ewkb) {
        this(ewkb, GeometryUtil.extractSrid(ewkb));
    }

    public byte[] getBytes() {
        return this.wkb;
    }

    public Integer getSrid() {
        return this.srid;
    }

    public boolean isExtended() {
        return GeometryUtil.isExtended(this.wkb);
    }

    public boolean isEmptyGeometryCollection() {
        if (this.wkb == null || this.wkb.length < 5) {
            return false;
        }
        ByteBuffer buffer = ByteBuffer.wrap(this.wkb);
        buffer.order(GeometryUtil.getByteOrder(buffer.get()));
        EmptyGeometryCollectionVisitor visitor = new EmptyGeometryCollectionVisitor();
        GeometryTraverser.traverse(buffer, visitor);
        return visitor.isGeometryCollection && visitor.isEmpty;
    }

    public GeometryBytes swapCoordinates() {
        return GeometryCoordinateSwapper.swap(this);
    }

    public GeometryBytes swapCoordinatesNoCheck() {
        return GeometryCoordinateSwapper.swapNoCheck(this);
    }

    public GeometryBytes asExtendedWkb() {
        return GeometryFormatConverter.toExtendedWkb(this);
    }

    public GeometryBytes asWkb() {
        return GeometryFormatConverter.toWkb(this);
    }

    public GeometryBytes asLittleEndian() {
        return GeometryEndiannessConverter.toLittleEndian(this);
    }

    public GeometryBytes asBigEndian() {
        return GeometryEndiannessConverter.toBigEndian(this);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeometryBytes geometry = (GeometryBytes)o;
        return Objects.deepEquals(this.wkb, geometry.wkb) && Objects.equals(this.srid, geometry.srid);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.wkb), this.srid);
    }

    public String toString() {
        return "GeometryBytes{wkb=" + HexConverter.convertToHexString(this.wkb) + ", srid=" + this.srid + "}";
    }

    static class EmptyGeometryCollectionVisitor
    implements GeometryVisitor {
        boolean isGeometryCollection = false;
        boolean isEmpty = true;

        EmptyGeometryCollectionVisitor() {
        }

        @Override
        public void startGeometryCollection(int geometryCount) {
            this.isGeometryCollection = true;
            this.isEmpty = geometryCount == 0;
        }
    }
}

