/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalTableFilters;
import io.debezium.relational.TableId;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.HistorizedDatabaseSchema;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuardrailValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuardrailValidator.class);
    private final CommonConnectorConfig connectorConfig;
    private final RelationalTableFilters tableFilters;
    private final Boolean storeOnlyCapturedTables;
    private final Boolean storeOnlyCapturedDatabases;

    public GuardrailValidator(CommonConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
        this.tableFilters = null;
        this.storeOnlyCapturedTables = null;
        this.storeOnlyCapturedDatabases = null;
    }

    public GuardrailValidator(CommonConnectorConfig connectorConfig, DatabaseSchema<?> schema) {
        this.connectorConfig = connectorConfig;
        if (connectorConfig instanceof RelationalDatabaseConnectorConfig) {
            RelationalDatabaseConnectorConfig relationalConfig = (RelationalDatabaseConnectorConfig)connectorConfig;
            this.tableFilters = relationalConfig.getTableFilters();
        } else {
            this.tableFilters = null;
        }
        if (schema instanceof HistorizedDatabaseSchema) {
            HistorizedDatabaseSchema historizedSchema = (HistorizedDatabaseSchema)schema;
            this.storeOnlyCapturedTables = historizedSchema.storeOnlyCapturedTables();
            this.storeOnlyCapturedDatabases = historizedSchema.storeOnlyCapturedDatabases();
        } else {
            this.storeOnlyCapturedTables = null;
            this.storeOnlyCapturedDatabases = null;
        }
    }

    public void validate(Set<TableId> allTableIds) {
        List<String> tableNames;
        boolean isValidatingAllTables = Boolean.FALSE.equals(this.storeOnlyCapturedTables);
        if (isValidatingAllTables) {
            tableNames = allTableIds.stream().filter(tableId -> this.tableFilters.eligibleForSchemaDataCollectionFilter().isIncluded((TableId)tableId)).map(TableId::toString).collect(Collectors.toList());
            LOGGER.info("Validating guardrail limits against {} tables present in {}", (Object)tableNames.size(), (Object)(Boolean.TRUE.equals(this.storeOnlyCapturedDatabases) ? "the captured databases" : "all databases"));
        } else {
            tableNames = allTableIds.stream().filter(tableId -> this.tableFilters.dataCollectionFilter().isIncluded((TableId)tableId)).map(TableId::toString).collect(Collectors.toList());
            LOGGER.info("Validating guardrail limits against {} captured tables", (Object)tableNames.size());
        }
        this.connectorConfig.validateGuardrailLimits(tableNames, isValidatingAllTables);
    }

    public void validate(Collection<String> collectionNames) {
        LOGGER.info("Validating guardrail limits against {} captured collections", (Object)collectionNames.size());
        this.connectorConfig.validateGuardrailLimits(collectionNames);
    }
}

