/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.spatial;

import io.debezium.DebeziumException;
import io.debezium.spatial.GeometryBytes;
import io.debezium.spatial.GeometryTraverser;
import io.debezium.spatial.GeometryUtil;
import io.debezium.spatial.GeometryVisitor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

class GeometryEndiannessConverter {
    GeometryEndiannessConverter() {
    }

    public static GeometryBytes toLittleEndian(GeometryBytes geometry) {
        return GeometryEndiannessConverter.convert(geometry, ByteOrder.LITTLE_ENDIAN);
    }

    public static GeometryBytes toBigEndian(GeometryBytes geometry) {
        return GeometryEndiannessConverter.convert(geometry, ByteOrder.BIG_ENDIAN);
    }

    private static GeometryBytes convert(GeometryBytes geometry, ByteOrder targetByteOrder) {
        try {
            ByteBuffer input = ByteBuffer.wrap(geometry.getBytes());
            input.order(GeometryUtil.getByteOrder(input.get()));
            ByteBuffer output = ByteBuffer.allocate(geometry.getBytes().length);
            output.put(GeometryUtil.getByteOrderByte(targetByteOrder));
            output.order(targetByteOrder);
            GeometryTraverser.traverse(input, new EndianConverterVisitor(output, targetByteOrder));
            return new GeometryBytes(output.array(), geometry.getSrid());
        }
        catch (Exception e) {
            throw new DebeziumException("Failed to convert geometry endianness", (Throwable)e);
        }
    }

    private record EndianConverterVisitor(ByteBuffer output, ByteOrder targetByteOrder) implements GeometryVisitor
    {
        @Override
        public boolean enterGeometry(int wkbType, boolean hasZ, boolean hasM, int stride) {
            this.output.putInt(wkbType);
            return true;
        }

        @Override
        public boolean enterCollectionGeometry(byte byteOrder) {
            this.output.put(GeometryUtil.getByteOrderByte(this.targetByteOrder));
            return true;
        }

        @Override
        public boolean enterSubGeometry(byte byteOrder, int wkbType) {
            this.output.put(GeometryUtil.getByteOrderByte(this.targetByteOrder));
            this.output.putInt(wkbType);
            return true;
        }

        @Override
        public void visitSrid(int srid) {
            this.output.putInt(srid);
        }

        @Override
        public void visitCoordinate(double[] ordinates) {
            Arrays.stream(ordinates).forEach(this.output::putDouble);
        }

        @Override
        public void startLineString(int pointCount) {
            this.output.putInt(pointCount);
        }

        @Override
        public void startPolygon(int ringCount) {
            this.output.putInt(ringCount);
        }

        @Override
        public void startRing(int ringIndex, int pointCount) {
            this.output.putInt(pointCount);
        }

        @Override
        public void startMultiPoint(int pointCount) {
            this.output.putInt(pointCount);
        }

        @Override
        public void startMultiLineString(int lineStringCount) {
            this.output.putInt(lineStringCount);
        }

        @Override
        public void startMultiPolygon(int polygonCount) {
            this.output.putInt(polygonCount);
        }

        @Override
        public void startGeometryCollection(int geometryCount) {
            this.output.putInt(geometryCount);
        }
    }
}

