/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.common;

import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.connect.storage.OffsetStorageReader;

public class OffsetReader<P extends Partition, O extends OffsetContext, L extends OffsetContext.Loader<O>> {
    private final OffsetStorageReader reader;
    private final L loader;

    public OffsetReader(OffsetStorageReader reader, L loader) {
        this.reader = reader;
        this.loader = loader;
    }

    public Map<P, O> offsets(Set<P> partitions) {
        Set sourcePartitions = partitions.stream().map(Partition::getSupportedFormats).flatMap(Collection::stream).collect(Collectors.toCollection(HashSet::new));
        Map sourceOffsets = this.reader.offsets((Collection)sourcePartitions);
        LinkedHashMap offsets = new LinkedHashMap();
        partitions.forEach(partition -> {
            Optional<Map> sourceOffset = partition.getSupportedFormats().stream().map(sourceOffsets::get).filter(Objects::nonNull).findFirst();
            Object offset = null;
            if (sourceOffset.isPresent()) {
                offset = this.loader.load(sourceOffset.get());
            }
            offsets.put(partition, offset);
        });
        return offsets;
    }
}

