/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.Module;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.data.Envelope;
import io.debezium.transforms.ExtractNewRecordStateConfigDefinition;
import io.debezium.transforms.SmtManager;
import io.debezium.transforms.extractnewstate.DefaultDeleteHandlingStrategy;
import io.debezium.transforms.extractnewstate.ExtractRecordStrategy;
import io.debezium.util.Strings;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExtractNewRecordState<R extends ConnectRecord<R>>
implements Transformation<R>,
Versioned {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractExtractNewRecordState.class);
    private static final Pattern FIELD_SEPARATOR = Pattern.compile("\\.");
    private static final Pattern NEW_FIELD_SEPARATOR = Pattern.compile(":");
    private static final String UPDATE_DESCRIPTION = "updateDescription";
    protected static final String PURPOSE = "source field insertion";
    protected Configuration config;
    protected SmtManager<R> smtManager;
    protected ExtractRecordStrategy<R> extractRecordStrategy;
    protected List<FieldReference> additionalHeaders;
    protected List<FieldReference> additionalFields;
    protected String routeByField;

    public String version() {
        return Module.version();
    }

    public void configure(Map<String, ?> configs) {
        this.config = Configuration.from(configs);
        this.smtManager = new SmtManager(this.config);
        if (!this.config.validateAndRecord(this.validateConfigFields(), arg_0 -> ((Logger)LOGGER).error(arg_0))) {
            throw new ConnectException("Unable to validate config.");
        }
        String addFieldsPrefix = this.config.getString(ExtractNewRecordStateConfigDefinition.ADD_FIELDS_PREFIX);
        String addHeadersPrefix = this.config.getString(ExtractNewRecordStateConfigDefinition.ADD_HEADERS_PREFIX);
        this.additionalFields = FieldReference.fromConfiguration(addFieldsPrefix, this.config.getString(ExtractNewRecordStateConfigDefinition.ADD_FIELDS));
        this.additionalHeaders = FieldReference.fromConfiguration(addHeadersPrefix, this.config.getString(ExtractNewRecordStateConfigDefinition.ADD_HEADERS));
        String routeFieldConfig = this.config.getString(ExtractNewRecordStateConfigDefinition.ROUTE_BY_FIELD);
        this.routeByField = routeFieldConfig.isEmpty() ? null : routeFieldConfig;
        ExtractNewRecordStateConfigDefinition.DeleteTombstoneHandling deleteTombstoneHandling = ExtractNewRecordStateConfigDefinition.DeleteTombstoneHandling.parse(this.config.getString(ExtractNewRecordStateConfigDefinition.HANDLE_TOMBSTONE_DELETES));
        this.extractRecordStrategy = new DefaultDeleteHandlingStrategy(deleteTombstoneHandling, this.config.getBoolean(ExtractNewRecordStateConfigDefinition.REPLACE_NULL_WITH_DEFAULT));
    }

    public R apply(R record) {
        return this.doApply(record);
    }

    protected abstract R doApply(R var1);

    protected abstract Iterable<Field> validateConfigFields();

    public void close() {
        if (this.extractRecordStrategy != null) {
            this.extractRecordStrategy.close();
        }
    }

    protected R setTopic(String updatedTopicValue, R record) {
        return (R)(Strings.isNullOrBlank(updatedTopicValue) ? record : record.newRecord(updatedTopicValue, record.kafkaPartition(), record.keySchema(), record.key(), record.valueSchema(), record.value(), record.timestamp()));
    }

    protected Headers makeHeaders(List<FieldReference> additionalHeaders, Struct originalRecordValue) {
        ConnectHeaders headers = new ConnectHeaders();
        for (FieldReference fieldReference : additionalHeaders) {
            if (originalRecordValue == null) {
                if (!"op".equals(fieldReference.getField())) continue;
                headers.addString(fieldReference.getNewField(), Envelope.Operation.DELETE.code());
                continue;
            }
            Optional<Schema> schema = fieldReference.getSchema(originalRecordValue.schema());
            schema.ifPresent(arg_0 -> AbstractExtractNewRecordState.lambda$makeHeaders$0((Headers)headers, fieldReference, originalRecordValue, arg_0));
        }
        return headers;
    }

    protected Header getHeaderByName(R record, String headerName) {
        for (Header header : record.headers()) {
            if (!header.key().equals(headerName)) continue;
            return header;
        }
        return null;
    }

    private static /* synthetic */ void lambda$makeHeaders$0(Headers headers, FieldReference fieldReference, Struct originalRecordValue, Schema value) {
        headers.add(fieldReference.getNewField(), fieldReference.getValue(originalRecordValue), value);
    }

    protected static class FieldReference {
        private final String struct;
        private final String field;
        private final String newField;

        private FieldReference(String prefix, String field) {
            String[] parts = NEW_FIELD_SEPARATOR.split(field);
            String[] splits = FIELD_SEPARATOR.split(parts[0]);
            this.field = splits.length == 1 ? splits[0] : splits[1];
            String string = this.struct = splits.length == 1 ? FieldReference.determineStruct(this.field) : splits[0];
            if (parts.length == 1) {
                this.newField = prefix + (String)(splits.length == 1 ? this.field : this.struct + "_" + this.field);
            } else if (parts.length == 2) {
                this.newField = prefix + parts[1];
            } else {
                throw new IllegalArgumentException("Unexpected field name: " + field);
            }
        }

        private static String determineStruct(String simpleFieldName) {
            switch (simpleFieldName) {
                case "id": 
                case "data_collection_order": 
                case "total_order": {
                    return "transaction";
                }
                case "op": 
                case "ts_ms": 
                case "ts_us": 
                case "ts_ns": {
                    return null;
                }
                case "updateDescription": {
                    return AbstractExtractNewRecordState.UPDATE_DESCRIPTION;
                }
            }
            return "source";
        }

        public static List<FieldReference> fromConfiguration(String fieldPrefix, String addHeadersConfig) {
            if (Strings.isNullOrEmpty(addHeadersConfig)) {
                return Collections.emptyList();
            }
            return Arrays.stream(addHeadersConfig.split(",")).map(String::trim).map(field -> new FieldReference(fieldPrefix, (String)field)).collect(Collectors.toList());
        }

        protected String getField() {
            return this.field;
        }

        public String getNewField() {
            return this.newField;
        }

        public Object getValue(Struct originalRecordValue) {
            Struct parentStruct = this.struct != null ? (Struct)originalRecordValue.getWithoutDefault(this.struct) : originalRecordValue;
            return parentStruct != null ? this.getWithoutDefault(parentStruct, originalRecordValue) : null;
        }

        private Object getWithoutDefault(Struct parentStruct, Struct originalRecordValue) {
            return this.isInSchema(parentStruct.schema()) ? parentStruct.getWithoutDefault(this.field) : originalRecordValue.getWithoutDefault(this.field);
        }

        public Optional<Schema> getSchema(Schema originalRecordSchema) {
            Optional<org.apache.kafka.connect.data.Field> extractedField = this.getField(originalRecordSchema);
            return extractedField.map(value -> SchemaUtil.copySchemaBasics((Schema)value.schema()).optional().build());
        }

        private Optional<org.apache.kafka.connect.data.Field> getField(Schema originalRecordSchema) {
            Schema parentSchema = this.struct != null ? originalRecordSchema.field(this.struct).schema() : originalRecordSchema;
            org.apache.kafka.connect.data.Field schemaField = parentSchema.field(this.field);
            if (schemaField == null) {
                LOGGER.debug("Field {} not found in {}. Trying in main payload", (Object)this.field, (Object)this.struct);
                if (!this.isInSchema(originalRecordSchema)) {
                    return Optional.empty();
                }
                schemaField = originalRecordSchema.field(this.field);
            }
            return Optional.of(schemaField);
        }

        private boolean isInSchema(Schema originalRecordSchema) {
            return originalRecordSchema.field(this.field) != null;
        }
    }

    protected static class NewRecordValueMetadata {
        private final Schema schema;
        private final String operation;

        NewRecordValueMetadata(Schema schema, String operation) {
            this.schema = schema;
            this.operation = operation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NewRecordValueMetadata metadata = (NewRecordValueMetadata)o;
            return Objects.equals(this.schema, metadata.schema) && Objects.equals(this.operation, metadata.operation);
        }

        public int hashCode() {
            return Objects.hash(this.schema, this.operation);
        }

        public String toString() {
            return "NewRecordValueMetadata{" + String.valueOf(this.schema) + ":" + this.operation + "}";
        }
    }
}

