/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.openlineage;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.openlineage.OpenLineageConfig;
import java.util.Map;
import java.util.stream.Collectors;

public record DebeziumOpenLineageConfiguration(boolean enabled, Config config, Job job) {
    private static final String KEY_VALUE_SEPARATOR = "=";
    private static final String LIST_SEPARATOR = ",";

    public static DebeziumOpenLineageConfiguration from(Configuration configuration) {
        Map<String, String> tags = configuration.getList(OpenLineageConfig.OPEN_LINEAGE_INTEGRATION_JOB_TAGS, LIST_SEPARATOR, pair -> pair.split(KEY_VALUE_SEPARATOR)).stream().collect(Collectors.toMap(pair -> pair[0].trim(), pair -> pair[1].trim()));
        Map<String, String> owners = configuration.getList(OpenLineageConfig.OPEN_LINEAGE_INTEGRATION_JOB_OWNERS, LIST_SEPARATOR, pair -> pair.split(KEY_VALUE_SEPARATOR)).stream().collect(Collectors.toMap(pair -> pair[0].trim(), pair -> pair[1].trim()));
        return new DebeziumOpenLineageConfiguration(configuration.getBoolean(OpenLineageConfig.OPEN_LINEAGE_INTEGRATION_ENABLED), new Config(configuration.getString(OpenLineageConfig.OPEN_LINEAGE_INTEGRATION_CONFIG_FILE_PATH)), new Job(configuration.getString(OpenLineageConfig.OPEN_LINEAGE_INTEGRATION_JOB_NAMESPACE, configuration.getString(CommonConnectorConfig.TOPIC_PREFIX)), configuration.getString(OpenLineageConfig.OPEN_LINEAGE_INTEGRATION_JOB_DESCRIPTION), tags, owners));
    }

    public record Config(String path) {
    }

    public record Job(String namespace, String description, Map<String, String> tags, Map<String, String> owners) {
    }
}

