/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.relational.history.SchemaHistoryException;
import io.debezium.relational.history.SchemaHistoryListener;
import io.debezium.relational.history.TableChanges;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;

public interface SchemaHistory {
    public static final String CONFIGURATION_FIELD_PREFIX_STRING = "schema.history.internal.";
    public static final Field NAME = Field.create("schema.history.internal.name").withDisplayName("Logical name for the database schema history").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("The name used for the database schema history, perhaps differently by each implementation.").withValidation(Field::isOptional);
    public static final Field SKIP_UNPARSEABLE_DDL_STATEMENTS = Field.create("schema.history.internal.skip.unparseable.ddl").withDisplayName("Skip DDL statements that cannot be parsed").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Controls the action Debezium will take when it meets a DDL statement in binlog, that it cannot parse.By default the connector will stop operating but by changing the setting it can ignore the statements which it cannot parse. If skipping is enabled then Debezium can miss metadata changes.").withDefault(false);
    public static final Field STORE_ONLY_CAPTURED_TABLES_DDL = Field.create("schema.history.internal.store.only.captured.tables.ddl").withDisplayName("Store only DDL that modifies tables that are captured based on include/exclude lists").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Controls what DDL will Debezium store in database schema history. By default (false) Debezium will store all incoming DDL statements. If set to true, then only DDL that manipulates a captured table will be stored.").withDefault(false);
    public static final Field STORE_ONLY_CAPTURED_DATABASES_DDL = Field.create("schema.history.internal.store.only.captured.databases.ddl").withDisplayName("Store only DDL that modifies tables of databases that are captured based on include/exclude lists").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Controls what DDL will Debezium store in database schema history. By default (false) Debezium will store all incoming DDL statements. If set to true, then only DDL that manipulates a table from captured schema/database will be stored.").withDefault(false);
    public static final Field DDL_FILTER = Field.createInternal("schema.history.internal.ddl.filter").withDisplayName("DDL filter").withType(ConfigDef.Type.STRING).withDefault("DROP TEMPORARY TABLE IF EXISTS .+ /\\* generated by server \\*/,(SET STATEMENT .*)?INSERT INTO (mysql\\.)?rds_heartbeat2\\(.*\\) values \\(.*\\) ON DUPLICATE KEY UPDATE value = .*,(SET STATEMENT .*)?DELETE FROM (mysql\\.)?rds_sysinfo.*,(SET STATEMENT .*)?INSERT INTO (mysql\\.)?rds_sysinfo\\(.*\\) values \\(.*\\),(SET STATEMENT .*)?INSERT INTO (mysql\\.)?rds_monitor\\(.*\\) values \\(.*\\) ON DUPLICATE KEY UPDATE value = .*,(SET STATEMENT .*)?INSERT INTO (mysql\\.)?rds_monitor\\(.*\\) values \\(.*\\),(SET STATEMENT .*)?DELETE FROM (mysql\\.)?rds_monitor.*,FLUSH RELAY LOGS.*,flush relay logs.*,SAVEPOINT .*,^\\s*#\\s*Dummy event.*").withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withDescription("A regular expression to filter out a subset of incoming DDL statements from processing and storing into schema history evolution.").withValidation(Field::isListOfRegex);
    public static final Field INTERNAL_CONNECTOR_CLASS = Field.create("schema.history.internal.connector.class").withDisplayName("Debezium connector class").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withDescription("The class of the Debezium database connector").withNoValidation();
    public static final Field INTERNAL_CONNECTOR_ID = Field.create("schema.history.internal.connector.id").withDisplayName("Debezium connector identifier").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("The unique identifier of the Debezium connector").withNoValidation();
    public static final Field INTERNAL_PREFER_DDL = Field.create("schema.history.internal.prefer.ddl").withDisplayName("Prefer DDL for schema recovery").withType(ConfigDef.Type.BOOLEAN).withDefault(false).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Prefer DDL for schema recovery in case logical schema is present").withInvisibleRecommender().withNoValidation();

    public void configure(Configuration var1, HistoryRecordComparator var2, SchemaHistoryListener var3, boolean var4);

    public void start();

    public void record(Map<String, ?> var1, Map<String, ?> var2, String var3, String var4) throws SchemaHistoryException;

    public void record(Map<String, ?> var1, Map<String, ?> var2, String var3, String var4, String var5, TableChanges var6, Instant var7) throws SchemaHistoryException;

    @Deprecated
    default public void recover(Map<String, ?> source, Map<String, ?> position, Tables schema, DdlParser ddlParser) {
        this.recover(Collections.singletonMap(source, position), schema, ddlParser);
    }

    default public void recover(Offsets<?, ?> offsets, Tables schema, DdlParser ddlParser) {
        HashMap offsetMap = new HashMap();
        for (Map.Entry<?, ?> entry : offsets) {
            if (entry.getValue() == null) continue;
            offsetMap.put(((Partition)entry.getKey()).getSourcePartition(), ((OffsetContext)entry.getValue()).getOffset());
        }
        this.recover(offsetMap, schema, ddlParser);
    }

    @Deprecated
    public void recover(Map<Map<String, ?>, Map<String, ?>> var1, Tables var2, DdlParser var3);

    public void stop();

    public boolean exists();

    public boolean storageExists();

    public void initializeStorage();
}

