/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.mapping;

import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.debezium.relational.mapping.ColumnMapper;
import io.debezium.util.Strings;
import java.util.Locale;
import org.apache.kafka.connect.data.SchemaBuilder;

public class PropagateSourceMetadataToSchemaParameter
implements ColumnMapper {
    public static final String TYPE_NAME_PARAMETER_KEY = "__debezium.source.column.type";
    public static final String TYPE_LENGTH_PARAMETER_KEY = "__debezium.source.column.length";
    public static final String TYPE_SCALE_PARAMETER_KEY = "__debezium.source.column.scale";
    public static final String COLUMN_COMMENT_PARAMETER_KEY = "__debezium.source.column.comment";
    public static final String COLUMN_NAME_PARAMETER_KEY = "__debezium.source.column.name";

    @Override
    public ValueConverter create(Column column) {
        return null;
    }

    @Override
    public void alterFieldSchema(Column column, SchemaBuilder schemaBuilder) {
        schemaBuilder.parameter(TYPE_NAME_PARAMETER_KEY, column.typeName().toUpperCase(Locale.ENGLISH));
        if (column.length() != -1) {
            schemaBuilder.parameter(TYPE_LENGTH_PARAMETER_KEY, String.valueOf(column.length()));
        }
        if (column.scale().isPresent()) {
            schemaBuilder.parameter(TYPE_SCALE_PARAMETER_KEY, String.valueOf(column.scale().get()));
        }
        if (!Strings.isNullOrEmpty(column.comment())) {
            schemaBuilder.parameter(COLUMN_COMMENT_PARAMETER_KEY, column.comment());
        }
        schemaBuilder.parameter(COLUMN_NAME_PARAMETER_KEY, column.name());
    }
}

