/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.document;

import io.debezium.annotation.Immutable;
import io.debezium.document.Path;
import io.debezium.util.HashCode;
import io.debezium.util.Iterators;
import io.debezium.util.Joiner;
import io.debezium.util.Strings;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;

@Immutable
final class Paths {
    private static final Pattern PATH_SEPARATOR_PATTERN = Pattern.compile("/");

    static Path parse(String path, boolean resolveJsonPointerEscapes) {
        if ((path = Strings.trim(path, c -> c < ' ' || c == '/')).length() == 0) {
            return RootPath.INSTANCE;
        }
        String[] segments = PATH_SEPARATOR_PATTERN.split(path);
        if (segments.length == 1) {
            return new SingleSegmentPath(Paths.parseSegment(segments[0], resolveJsonPointerEscapes));
        }
        if (resolveJsonPointerEscapes) {
            for (int i = 0; i != segments.length; ++i) {
                segments[i] = Paths.parseSegment(segments[i], true);
            }
        }
        return new MultiSegmentPath(segments);
    }

    private static String parseSegment(String segment, boolean resolveJsonPointerEscapes) {
        if (resolveJsonPointerEscapes) {
            segment = segment.replaceAll("\\~1", "/").replaceAll("\\~0", "~");
        }
        return segment;
    }

    static int copyPathInto(Path path, String[] segments, int start) {
        if (path instanceof InnerPath) {
            return ((InnerPath)((Object)path)).copyInto(segments, start);
        }
        int i = start;
        for (String segment : path) {
            segments[i++] = segment;
        }
        return i;
    }

    private Paths() {
    }

    static final class RootPath
    implements Path,
    InnerPath {
        public static final Path INSTANCE = new RootPath();
        public static final Optional<Path> OPTIONAL_OF_ROOT = Optional.of(INSTANCE);

        private RootPath() {
        }

        @Override
        public Optional<Path> parent() {
            return Optional.empty();
        }

        @Override
        public Optional<String> lastSegment() {
            return Optional.empty();
        }

        @Override
        public int size() {
            return 0;
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public String toString() {
            return "/";
        }

        @Override
        public String toRelativePath() {
            return "";
        }

        @Override
        public Iterator<String> iterator() {
            return Iterators.empty();
        }

        @Override
        public void forEach(Consumer<? super String> consumer) {
        }

        @Override
        public Path subpath(int length) {
            if (length != 0) {
                throw new IllegalArgumentException("Invalid subpath length: " + length);
            }
            return this;
        }

        @Override
        public String segment(int index) {
            throw new IllegalArgumentException("Invalid segment index: " + index);
        }

        @Override
        public Path append(Path relPath) {
            return relPath;
        }

        @Override
        public int copyInto(String[] segments, int start) {
            return 0;
        }
    }

    static final class SingleSegmentPath
    implements Path,
    InnerPath {
        private final Optional<String> segment;

        protected SingleSegmentPath(String segment) {
            assert (segment != null);
            this.segment = Optional.of(segment);
        }

        @Override
        public Optional<Path> parent() {
            return Path.optionalRoot();
        }

        @Override
        public Optional<String> lastSegment() {
            return this.segment;
        }

        @Override
        public int size() {
            return 1;
        }

        public int hashCode() {
            return this.segment.get().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Path) {
                Path that = (Path)obj;
                if (this.size() != that.size()) {
                    return false;
                }
                return this.lastSegment().get().equals(that.lastSegment().get());
            }
            return false;
        }

        public String toString() {
            return "/" + this.segment.get();
        }

        @Override
        public String toRelativePath() {
            return this.segment.get();
        }

        @Override
        public Iterator<String> iterator() {
            return Iterators.with(this.segment.get());
        }

        @Override
        public void forEach(Consumer<? super String> consumer) {
            consumer.accept(this.segment.get());
        }

        @Override
        public Path subpath(int length) {
            if (length > this.size() || length < 0) {
                throw new IllegalArgumentException("Invalid subpath length: " + length);
            }
            return length == 1 ? this : Path.root();
        }

        @Override
        public String segment(int index) {
            if (index >= this.size() || index < 0) {
                throw new IllegalArgumentException("Invalid segment index: " + index);
            }
            return this.segment.get();
        }

        @Override
        public Path append(Path relPath) {
            if (relPath.isRoot()) {
                return this;
            }
            if (relPath.isSingle()) {
                return new ChildPath(this, relPath.lastSegment().get());
            }
            String[] segments = new String[this.size() + relPath.size()];
            int offset = this.copyInto(segments, 0);
            Paths.copyPathInto(relPath, segments, offset);
            return new MultiSegmentPath(segments);
        }

        @Override
        public int copyInto(String[] segments, int start) {
            segments[start] = this.segment.get();
            return 1;
        }
    }

    static final class MultiSegmentPath
    implements Path,
    InnerPath {
        private final String[] segments;
        private final int hc;

        protected MultiSegmentPath(String[] segments) {
            this.segments = segments;
            assert (this.size() > 1);
            this.hc = HashCode.compute(segments[0].hashCode(), segments[1].hashCode());
        }

        @Override
        public Optional<Path> parent() {
            if (this.size() == 2) {
                return Optional.of(new SingleSegmentPath(this.segments[0]));
            }
            return Optional.of(new MultiSegmentPath(Arrays.copyOf(this.segments, this.segments.length - 1)));
        }

        @Override
        public Optional<String> lastSegment() {
            return Optional.of(this.segments[this.segments.length - 1]);
        }

        @Override
        public int size() {
            return this.segments.length;
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Path) {
                Path that = (Path)obj;
                if (this.size() != that.size()) {
                    return false;
                }
                Iterator<String> thisIter = this.iterator();
                Iterator thatIter = that.iterator();
                while (thisIter.hasNext()) {
                    if (thisIter.next().equals(thatIter.next())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return Joiner.on("/", "/").join(this.segments);
        }

        @Override
        public String toRelativePath() {
            return Joiner.on("", "/").join(this.segments);
        }

        @Override
        public Iterator<String> iterator() {
            return Iterators.with(this.segments);
        }

        @Override
        public void forEach(Consumer<? super String> consumer) {
            for (String segment : this.segments) {
                consumer.accept(segment);
            }
        }

        @Override
        public Path subpath(int length) {
            if (length > this.size() || length < 0) {
                throw new IllegalArgumentException("Invalid subpath length: " + length);
            }
            if (length == 0) {
                return RootPath.INSTANCE;
            }
            if (length == 1) {
                return new SingleSegmentPath(this.segments[0]);
            }
            if (length == this.size()) {
                return this;
            }
            return new MultiSegmentPath(Arrays.copyOf(this.segments, length));
        }

        @Override
        public String segment(int index) {
            if (index >= this.size() || index < 0) {
                throw new IllegalArgumentException("Invalid segment index: " + index);
            }
            return this.segments[index];
        }

        @Override
        public Path append(Path relPath) {
            if (relPath.isRoot()) {
                return this;
            }
            if (relPath.isSingle()) {
                return new ChildPath(this, relPath.lastSegment().get());
            }
            String[] segments = new String[this.size() + relPath.size()];
            int offset = this.copyInto(segments, 0);
            Paths.copyPathInto(relPath, segments, offset);
            return new MultiSegmentPath(segments);
        }

        @Override
        public int copyInto(String[] segments, int start) {
            System.arraycopy(this.segments, 0, segments, start, this.segments.length);
            return this.segments.length;
        }
    }

    static interface InnerPath {
        public int copyInto(String[] var1, int var2);
    }

    static final class ChildPath
    implements Path,
    InnerPath {
        private final Path parent;
        private final String segment;

        protected ChildPath(Path parent, String segment) {
            assert (parent instanceof InnerPath);
            this.parent = parent;
            this.segment = segment;
        }

        @Override
        public Iterator<String> iterator() {
            return Iterators.join(this.parent, this.segment);
        }

        @Override
        public Optional<String> lastSegment() {
            return Optional.of(this.segment);
        }

        @Override
        public Optional<Path> parent() {
            return Optional.of(this.parent);
        }

        @Override
        public int size() {
            return this.parent.size() + 1;
        }

        public int hashCode() {
            return HashCode.compute(this.parent, this.segment);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Path) {
                Path that = (Path)obj;
                if (this.size() != that.size()) {
                    return false;
                }
                if (!this.parent.equals(that.parent())) {
                    return false;
                }
                return this.segment.equals(that.lastSegment().get());
            }
            return false;
        }

        public String toString() {
            return Joiner.on("/", "/").join(this.parent.toString(), this.segment);
        }

        @Override
        public String toRelativePath() {
            return Joiner.on("/").join(this.parent.toRelativePath(), this.segment);
        }

        @Override
        public String segment(int index) {
            if (index >= this.size() || index < 0) {
                throw new IllegalArgumentException("Invalid segment index: " + index);
            }
            return index < this.parent.size() ? this.parent.segment(index) : this.segment;
        }

        @Override
        public Path subpath(int length) {
            if (length > this.size() || length < 0) {
                throw new IllegalArgumentException("Invalid subpath length: " + length);
            }
            return length <= this.parent.size() ? this.parent.subpath(length) : this;
        }

        @Override
        public Path append(Path relPath) {
            if (relPath.isRoot()) {
                return this;
            }
            if (relPath.isSingle()) {
                return new ChildPath(this, relPath.lastSegment().get());
            }
            String[] segments = new String[this.size() + relPath.size() + 1];
            int offset = this.copyInto(segments, 0);
            Paths.copyPathInto(relPath, segments, offset);
            return new MultiSegmentPath(segments);
        }

        @Override
        public int copyInto(String[] segments, int start) {
            int copied = ((InnerPath)((Object)this.parent)).copyInto(segments, start);
            segments[copied] = this.segment;
            return this.size();
        }
    }
}

