/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import io.debezium.util.Clock;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Threads {
    private static final String DEBEZIUM_THREAD_NAME_PREFIX = "debezium-";
    private static final Logger LOGGER = LoggerFactory.getLogger(Threads.class);

    public static TimeSince timeSince(final Clock clock) {
        return new TimeSince(){
            private long lastTimeInMillis;

            @Override
            public void reset() {
                this.lastTimeInMillis = clock.currentTimeInMillis();
            }

            @Override
            public long elapsedTime() {
                long elapsed = clock.currentTimeInMillis() - this.lastTimeInMillis;
                return Math.max(elapsed, 0L);
            }
        };
    }

    public static Timer timer(Clock clock, final Duration time) {
        final TimeSince start = Threads.timeSince(clock);
        start.reset();
        return new Timer(){

            @Override
            public boolean expired() {
                return start.elapsedTime() > time.toMillis();
            }

            @Override
            public Duration remaining() {
                return time.minus(start.elapsedTime(), ChronoUnit.MILLIS);
            }
        };
    }

    public static Thread interruptAfterTimeout(String threadName, long timeout, TimeUnit timeoutUnit, TimeSince elapsedTimer) {
        Thread threadToInterrupt = Thread.currentThread();
        return Threads.interruptAfterTimeout(threadName, timeout, timeoutUnit, elapsedTimer, threadToInterrupt);
    }

    public static Thread interruptAfterTimeout(String threadName, long timeout, TimeUnit timeoutUnit, TimeSince elapsedTimer, Thread threadToInterrupt) {
        return Threads.timeout(threadName, timeout, timeoutUnit, 100L, TimeUnit.MILLISECONDS, elapsedTimer::elapsedTime, elapsedTimer::reset, () -> threadToInterrupt.interrupt());
    }

    public static Thread timeout(String threadName, long timeout, TimeUnit timeoutUnit, TimeSince elapsedTimer, Runnable uponTimeout) {
        return Threads.timeout(threadName, timeout, timeoutUnit, 100L, TimeUnit.MILLISECONDS, elapsedTimer::elapsedTime, elapsedTimer::reset, uponTimeout);
    }

    public static Thread timeout(String threadName, long timeout, TimeUnit timeoutUnit, long sleepInterval, TimeUnit sleepUnit, TimeSince elapsedTimer, Runnable uponTimeout) {
        return Threads.timeout(threadName, timeout, timeoutUnit, sleepInterval, sleepUnit, elapsedTimer::elapsedTime, elapsedTimer::reset, uponTimeout);
    }

    public static Thread timeout(String threadName, long timeout, TimeUnit timeoutUnit, long sleepInterval, TimeUnit sleepUnit, LongSupplier elapsedTime, Runnable uponStart, Runnable uponTimeout) {
        long timeoutInMillis = timeoutUnit.toMillis(timeout);
        long sleepTimeInMillis = sleepUnit.toMillis(sleepInterval);
        Runnable r = () -> {
            if (uponStart != null) {
                uponStart.run();
            }
            while (elapsedTime.getAsLong() < timeoutInMillis) {
                try {
                    Thread.sleep(sleepTimeInMillis);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            uponTimeout.run();
        };
        return new Thread(r, "debezium--timeout-" + threadName);
    }

    private Threads() {
    }

    public static ThreadFactory threadFactory(Class<?> component, String componentId, String name, boolean indexed, boolean daemon) {
        return Threads.threadFactory(component, componentId, name, indexed, daemon, null);
    }

    public static ThreadFactory threadFactory(final Class<?> component, final String componentId, final String name, final boolean indexed, final boolean daemon, final Consumer<Thread> callback) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Requested thread factory for component {}, id = {} named = {}", new Object[]{component.getSimpleName(), componentId, name});
        }
        return new ThreadFactory(){
            private final AtomicInteger index = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                StringBuilder threadName = new StringBuilder(Threads.DEBEZIUM_THREAD_NAME_PREFIX).append(component.getSimpleName().toLowerCase()).append('-').append(componentId).append('-').append(name);
                if (indexed) {
                    threadName.append('-').append(this.index.getAndIncrement());
                }
                LOGGER.info("Creating thread {}", (Object)threadName);
                Thread t = new Thread(r, threadName.toString());
                t.setDaemon(daemon);
                if (callback != null) {
                    callback.accept(t);
                }
                return t;
            }
        };
    }

    public static ExecutorService newSingleThreadExecutor(Class<?> component, String componentId, String name, boolean daemon) {
        return Executors.newSingleThreadExecutor(Threads.threadFactory(component, componentId, name, false, daemon));
    }

    public static ExecutorService newFixedThreadPool(Class<?> component, String componentId, String name, int threadCount) {
        return Executors.newFixedThreadPool(threadCount, Threads.threadFactory(component, componentId, name, true, false));
    }

    public static ExecutorService newSingleThreadExecutor(Class<?> component, String componentId, String name) {
        return Threads.newSingleThreadExecutor(component, componentId, name, false);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(Class<?> component, String componentId, String name, boolean daemon) {
        return Executors.newSingleThreadScheduledExecutor(Threads.threadFactory(component, componentId, name, false, daemon));
    }

    public static interface TimeSince {
        public void reset();

        public long elapsedTime();
    }

    public static interface Timer {
        public boolean expired();

        public Duration remaining();
    }
}

