/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters.spi;

import io.debezium.converters.recordandmetadata.RecordAndMetadata;
import io.debezium.converters.spi.SerializerType;
import io.debezium.util.Collect;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public abstract class CloudEventsMaker {
    private static final String SCHEMA_URL_PATH = "/schemas/ids/";
    public static final String CLOUDEVENTS_SPECVERSION = "1.0";
    public static final String DATA_SCHEMA_NAME_PARAM = "dataSchemaName";
    public static final String CLOUDEVENTS_SCHEMA_SUFFIX = "CloudEvents.Envelope";
    private final RecordAndMetadata recordAndMetadata;
    private final SerializerType dataContentType;
    private final String dataSchemaUriBase;
    private final String cloudEventsSchemaName;
    private final String[] dataFields;
    static final Map<SerializerType, String> CONTENT_TYPE_NAME_MAP = Collect.hashMapOf(SerializerType.JSON, "application/json", SerializerType.AVRO, "application/avro");

    protected CloudEventsMaker(RecordAndMetadata recordAndMetadata, SerializerType dataContentType, String dataSchemaUriBase, String cloudEventsSchemaName, String ... dataFields) {
        this.recordAndMetadata = recordAndMetadata;
        this.dataContentType = dataContentType;
        this.dataSchemaUriBase = dataSchemaUriBase;
        this.cloudEventsSchemaName = cloudEventsSchemaName;
        this.dataFields = dataFields;
    }

    public abstract String ceId();

    public String ceSource(String logicalName) {
        return "/debezium/" + this.recordAndMetadata.connectorType() + "/" + logicalName;
    }

    public String ceSpecversion() {
        return CLOUDEVENTS_SPECVERSION;
    }

    public String ceType() {
        return "io.debezium.connector." + this.recordAndMetadata.connectorType() + ".DataChangeEvent";
    }

    public String ceDatacontenttype() {
        return CONTENT_TYPE_NAME_MAP.get((Object)this.dataContentType);
    }

    public String ceDataschemaUri(String schemaId) {
        return this.dataSchemaUriBase + SCHEMA_URL_PATH + schemaId;
    }

    public String ceTime() {
        long time = (Long)this.sourceField("ts_ms");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return formatter.format(time);
    }

    public Schema ceDataAttributeSchema() {
        return this.recordAndMetadata.dataSchema(this.dataFields);
    }

    public Struct ceDataAttribute() {
        return this.recordAndMetadata.data(this.dataFields);
    }

    public String ceSchemaName() {
        return this.cloudEventsSchemaName != null ? this.cloudEventsSchemaName : String.valueOf(this.sourceField("name")) + "." + String.valueOf(this.sourceField("db")) + ".CloudEvents.Envelope";
    }

    protected abstract Set<String> connectorSpecificSourceFields();

    protected Object sourceField(String name) {
        return this.recordAndMetadata.sourceField(name, this.connectorSpecificSourceFields());
    }

    public static final class FieldName {
        public static final String ID = "id";
        public static final String SOURCE = "source";
        public static final String SPECVERSION = "specversion";
        public static final String TYPE = "type";
        public static final String DATACONTENTTYPE = "datacontenttype";
        public static final String DATASCHEMA = "dataschema";
        public static final String SUBJECT = "subject";
        public static final String TIME = "time";
        public static final String DATA = "data";
        public static final String SCHEMA_FIELD_NAME = "schema";
        public static final String PAYLOAD_FIELD_NAME = "payload";
    }
}

