/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.debezium.Module;
import io.debezium.annotation.Immutable;
import io.debezium.config.Configuration;
import io.debezium.config.Instantiator;
import io.debezium.converters.CloudEventsConverterConfig;
import io.debezium.converters.recordandmetadata.RecordAndMetadataBaseImpl;
import io.debezium.converters.recordandmetadata.RecordAndMetadataHeaderImpl;
import io.debezium.converters.spi.CloudEventsMaker;
import io.debezium.converters.spi.CloudEventsProvider;
import io.debezium.converters.spi.CloudEventsValidator;
import io.debezium.converters.spi.RecordParser;
import io.debezium.converters.spi.SerializerType;
import io.debezium.data.Envelope;
import io.debezium.pipeline.txmetadata.TransactionMonitor;
import io.debezium.schema.SchemaNameAdjuster;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.json.JsonConverterConfig;
import org.apache.kafka.connect.json.JsonDeserializer;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.ConverterType;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventsConverter
implements Converter,
Versioned {
    private static final String EXTENSION_NAME_PREFIX = "iodebezium";
    private static final String TX_ATTRIBUTE_PREFIX = "tx";
    private static final String CONFLUENT_AVRO_CONVERTER_CLASS = "io.confluent.connect.avro.AvroConverter";
    private static final String CONFLUENT_SCHEMA_REGISTRY_URL_CONFIG = "schema.registry.url";
    private static final String APICURIO_AVRO_CONVERTER_CLASS = "io.apicurio.registry.utils.converter.AvroConverter";
    private static final String APICURIO_SCHEMA_REGISTRY_URL_CONFIG = "apicurio.registry.url";
    private static final String DATA_SCHEMA_SUFFIX = "-data";
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudEventsConverter.class);
    private static Method CONVERT_TO_CONNECT_METHOD;
    @Immutable
    private static final Map<String, CloudEventsProvider> PROVIDERS;
    private SerializerType ceSerializerType = SerializerType.withName("json");
    private SerializerType dataSerializerType = SerializerType.withName("json");
    private final JsonConverter jsonCloudEventsConverter = new JsonConverter();
    private JsonConverterConfig jsonCloudEventsConverterConfig = null;
    private JsonConverter jsonHeaderConverter = new JsonConverter();
    private final JsonConverter jsonDataConverter = new JsonConverter();
    private boolean enableJsonSchemas;
    private final JsonDeserializer jsonDeserializer = new JsonDeserializer();
    private Converter avroConverter;
    private List<String> schemaRegistryUrls;
    private SchemaNameAdjuster schemaNameAdjuster;
    private boolean extensionAttributesEnable;
    private String cloudEventsSchemaName;
    private CloudEventsConverterConfig.MetadataSource metadataSource;
    private final CloudEventsValidator cloudEventsValidator = new CloudEventsValidator();

    public CloudEventsConverter() {
        this(null);
    }

    public CloudEventsConverter(Converter avroConverter) {
        this.avroConverter = avroConverter;
    }

    public String version() {
        return Module.version();
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        HashMap conf = new HashMap(configs);
        Configuration jsonConfig = Configuration.from(configs).subset("json", true);
        conf.put("converter.type", ConverterType.VALUE.getName());
        CloudEventsConverterConfig ceConfig = new CloudEventsConverterConfig(conf);
        this.ceSerializerType = ceConfig.cloudeventsSerializerType();
        this.dataSerializerType = ceConfig.cloudeventsDataSerializerTypeConfig();
        this.schemaNameAdjuster = ceConfig.schemaNameAdjustmentMode().createAdjuster();
        this.extensionAttributesEnable = ceConfig.extensionAttributesEnable();
        this.cloudEventsSchemaName = ceConfig.schemaCloudEventsName();
        this.metadataSource = ceConfig.metadataSource();
        HashMap<String, Object> jsonHeaderConverterConfig = new HashMap<String, Object>();
        jsonHeaderConverterConfig.put("schemas.enable", true);
        jsonHeaderConverterConfig.put("converter.type", "header");
        this.jsonHeaderConverter.configure(jsonHeaderConverterConfig);
        boolean usingAvro = false;
        if (this.ceSerializerType == SerializerType.JSON) {
            Map<String, String> ceJsonConfig = jsonConfig.asMap();
            ceJsonConfig.put("schemas.enable", "false");
            this.configureConverterType(isKey, ceJsonConfig);
            this.jsonCloudEventsConverter.configure(ceJsonConfig, isKey);
            this.jsonCloudEventsConverterConfig = new JsonConverterConfig(ceJsonConfig);
        } else {
            usingAvro = true;
            if (this.dataSerializerType == SerializerType.JSON) {
                throw new IllegalStateException("Cannot use 'application/json' data content type within Avro events");
            }
        }
        if (this.dataSerializerType == SerializerType.JSON) {
            this.enableJsonSchemas = jsonConfig.getBoolean("schemas.enable", true);
            this.jsonDataConverter.configure(jsonConfig.asMap(), true);
        } else {
            usingAvro = true;
        }
        if (usingAvro) {
            Configuration avroConfig = Configuration.from(configs).subset("avro", true);
            boolean useApicurio = true;
            if (avroConfig.hasKey(APICURIO_SCHEMA_REGISTRY_URL_CONFIG)) {
                this.schemaRegistryUrls = avroConfig.getStrings(APICURIO_SCHEMA_REGISTRY_URL_CONFIG, ",");
            } else if (avroConfig.hasKey(CONFLUENT_SCHEMA_REGISTRY_URL_CONFIG)) {
                this.schemaRegistryUrls = avroConfig.getStrings(CONFLUENT_SCHEMA_REGISTRY_URL_CONFIG, ",");
                useApicurio = false;
            }
            if (this.schemaRegistryUrls == null || this.schemaRegistryUrls.isEmpty()) {
                throw new DataException("Need URL(s) for schema registry instances for CloudEvents when using Apache Avro");
            }
            if (this.avroConverter == null) {
                this.avroConverter = (Converter)Instantiator.getInstance(useApicurio ? APICURIO_AVRO_CONVERTER_CLASS : CONFLUENT_AVRO_CONVERTER_CLASS);
                LOGGER.info("Using Avro converter {}", (Object)this.avroConverter.getClass().getName());
                this.avroConverter.configure(avroConfig.asMap(), false);
            }
        }
        this.cloudEventsValidator.configure(this.ceSerializerType, this.cloudEventsSchemaName);
    }

    protected Map<String, String> configureConverterType(boolean isKey, Map<String, String> config) {
        config.put("converter.type", isKey ? "key" : "value");
        return config;
    }

    public byte[] fromConnectData(String topic, Schema schema, Object value) {
        return this.fromConnectData(topic, null, schema, value);
    }

    public byte[] fromConnectData(String topic, Headers headers, Schema schema, Object value) {
        if (schema == null || value == null) {
            return null;
        }
        if (this.metadataSource.global() == CloudEventsConverterConfig.MetadataSourceValue.VALUE ? !Envelope.isEnvelopeSchema(schema) : headers.lastHeader("source") == null || headers.lastHeader("op") == null) {
            return null;
        }
        if (schema.type() != Schema.Type.STRUCT) {
            throw new DataException("Mismatching schema");
        }
        Struct record = Requirements.requireStruct((Object)value, (String)"CloudEvents converter");
        Struct source = this.getSource(record, headers);
        CloudEventsProvider provider = CloudEventsConverter.lookupCloudEventsProvider(source);
        boolean useBaseImpl = Stream.of(this.metadataSource.global(), this.metadataSource.id(), this.metadataSource.type(), this.metadataSource.dataSchemaName()).allMatch(metadataSource -> metadataSource != CloudEventsConverterConfig.MetadataSourceValue.HEADER);
        RecordAndMetadataBaseImpl recordAndMetadata = useBaseImpl ? new RecordAndMetadataBaseImpl(record, schema) : new RecordAndMetadataHeaderImpl(record, schema, headers, this.metadataSource, this.jsonHeaderConverter);
        RecordParser parser = provider.createParser(recordAndMetadata);
        CloudEventsMaker maker = provider.createMaker(parser, this.dataSerializerType, this.schemaRegistryUrls == null ? null : String.join((CharSequence)",", this.schemaRegistryUrls), this.cloudEventsSchemaName);
        if (this.ceSerializerType == SerializerType.JSON) {
            if (this.dataSerializerType == SerializerType.JSON) {
                if (this.enableJsonSchemas) {
                    SchemaBuilder dummy = SchemaBuilder.struct();
                    SchemaAndValue cloudEvent = this.convertToCloudEventsFormat(parser, maker, (Schema)dummy, null, new Struct((Schema)dummy));
                    byte[] data = this.jsonDataConverter.fromConnectData(topic, maker.ceDataAttributeSchema(), (Object)maker.ceDataAttribute());
                    byte[] cloudEventJson = this.jsonCloudEventsConverter.fromConnectData(topic, cloudEvent.schema(), cloudEvent.value());
                    ByteBuffer cloudEventWithData = ByteBuffer.allocate(cloudEventJson.length + data.length - 2);
                    cloudEventWithData.put(cloudEventJson, 0, cloudEventJson.length - 3);
                    cloudEventWithData.put(data);
                    cloudEventWithData.put((byte)125);
                    return cloudEventWithData.array();
                }
                SchemaAndValue cloudEvent = this.convertToCloudEventsFormat(parser, maker, maker.ceDataAttributeSchema(), null, maker.ceDataAttribute());
                return this.jsonCloudEventsConverter.fromConnectData(topic, cloudEvent.schema(), cloudEvent.value());
            }
            SchemaAndValue cloudEvent = this.convertToCloudEventsFormatWithDataAsAvro(topic, parser, maker);
            return this.jsonCloudEventsConverter.fromConnectData(topic, cloudEvent.schema(), cloudEvent.value());
        }
        SchemaAndValue cloudEvent = this.convertToCloudEventsFormatWithDataAsAvro(topic + DATA_SCHEMA_SUFFIX, parser, maker);
        return this.avroConverter.fromConnectData(topic, cloudEvent.schema(), cloudEvent.value());
    }

    private static CloudEventsProvider lookupCloudEventsProvider(Struct source) {
        String connectorType = source.getString("connector");
        CloudEventsProvider provider = PROVIDERS.get(connectorType);
        if (provider != null) {
            return provider;
        }
        throw new DataException("No usable CloudEvents converters for connector type \"" + connectorType + "\"");
    }

    private Struct getSource(Struct record, Headers headers) {
        if (this.metadataSource.global() == CloudEventsConverterConfig.MetadataSourceValue.VALUE) {
            return record.getStruct("source");
        }
        Header header = headers.lastHeader("source");
        SchemaAndValue sav = this.jsonHeaderConverter.toConnectData(null, header.value());
        return (Struct)sav.value();
    }

    private SchemaAndValue convertToCloudEventsFormatWithDataAsAvro(String topic, RecordParser parser, CloudEventsMaker maker) {
        Schema dataSchemaType = Schema.BYTES_SCHEMA;
        byte[] serializedData = this.avroConverter.fromConnectData(topic, maker.ceDataAttributeSchema(), (Object)maker.ceDataAttribute());
        String dataSchemaUri = maker.ceDataschemaUri(this.getSchemaIdFromAvroMessage(serializedData));
        return this.convertToCloudEventsFormat(parser, maker, dataSchemaType, dataSchemaUri, serializedData);
    }

    private String getSchemaIdFromAvroMessage(byte[] serializedData) {
        return String.valueOf(ByteBuffer.wrap(serializedData, 1, 5).getInt());
    }

    public SchemaAndValue toConnectData(String topic, byte[] value) {
        switch (this.ceSerializerType) {
            case JSON: {
                try {
                    SchemaAndValue connectData = this.jsonCloudEventsConverter.toConnectData(topic, value);
                    this.cloudEventsValidator.verifyIsCloudEvent(connectData);
                    JsonNode jsonValue = this.jsonDeserializer.deserialize(topic, value);
                    SchemaAndValue dataField = this.reconvertData(topic, jsonValue.get("data"), this.dataSerializerType, this.enableJsonSchemas);
                    ((Map)connectData.value()).put("data", dataField.value());
                    return connectData;
                }
                catch (SerializationException e) {
                    throw new DataException("Converting byte[] to Kafka Connect data failed due to serialization error: ", (Throwable)e);
                }
            }
            case AVRO: {
                SchemaAndValue ceSchemaAndValue = this.avroConverter.toConnectData(topic, value);
                this.cloudEventsValidator.verifyIsCloudEvent(ceSchemaAndValue);
                Schema incompleteSchema = ceSchemaAndValue.schema();
                Struct ceValue = (Struct)ceSchemaAndValue.value();
                byte[] data = ceValue.getBytes("data");
                SchemaAndValue dataSchemaAndValue = this.avroConverter.toConnectData(topic + DATA_SCHEMA_SUFFIX, data);
                SchemaBuilder builder = SchemaBuilder.struct();
                for (Field field : incompleteSchema.fields()) {
                    if (field.name().equals("data")) {
                        builder.field(field.name(), dataSchemaAndValue.schema());
                        continue;
                    }
                    builder.field(field.name(), field.schema());
                }
                builder.name(incompleteSchema.name());
                builder.version(incompleteSchema.version());
                builder.doc(incompleteSchema.doc());
                if (incompleteSchema.parameters() != null) {
                    for (Map.Entry entry : incompleteSchema.parameters().entrySet()) {
                        builder.parameter((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                Schema schema = builder.build();
                Struct struct = new Struct(schema);
                for (Field field : schema.fields()) {
                    if (field.name().equals("data")) {
                        struct.put(field, dataSchemaAndValue.value());
                        continue;
                    }
                    struct.put(field, ceValue.get(field));
                }
                return new SchemaAndValue(schema, (Object)struct);
            }
        }
        return SchemaAndValue.NULL;
    }

    private SchemaAndValue reconvertData(String topic, JsonNode data, SerializerType dataType, Boolean enableSchemas) {
        try {
            byte[] serializedData = data.isBinary() ? data.binaryValue() : null;
            switch (dataType) {
                case JSON: {
                    JsonNode jsonValue;
                    JsonNode jsonNode = jsonValue = data.isBinary() ? this.jsonDeserializer.deserialize(topic, serializedData) : data;
                    if (!enableSchemas.booleanValue()) {
                        ObjectNode envelope = JsonNodeFactory.instance.objectNode();
                        envelope.set("schema", null);
                        envelope.set("payload", jsonValue);
                        jsonValue = envelope;
                    }
                    Schema schema = this.jsonCloudEventsConverter.asConnectSchema(jsonValue.get("schema"));
                    try {
                        return new SchemaAndValue(schema, CONVERT_TO_CONNECT_METHOD.getParameterCount() == 2 ? CONVERT_TO_CONNECT_METHOD.invoke((Object)this.jsonCloudEventsConverter, schema, jsonValue.get("payload")) : CONVERT_TO_CONNECT_METHOD.invoke((Object)this.jsonCloudEventsConverter, schema, jsonValue.get("payload"), this.jsonCloudEventsConverterConfig));
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new DataException(e.getCause());
                    }
                }
                case AVRO: {
                    return this.avroConverter.toConnectData(topic, serializedData);
                }
            }
            throw new DataException("No such serializer for \"" + this.dataSerializerType + "\" format");
        }
        catch (IOException e) {
            throw new DataException("Converting byte[] to Kafka Connect data failed due to serialization error: ", (Throwable)e);
        }
    }

    private SchemaAndValue convertToCloudEventsFormat(RecordParser parser, CloudEventsMaker maker, Schema dataSchemaType, String dataSchema, Object serializedData) {
        Struct source = parser.source();
        Schema sourceSchema = parser.source().schema();
        Struct transaction = parser.transaction();
        CESchemaBuilder ceSchemaBuilder = CloudEventsConverter.defineSchema().withName(this.schemaNameAdjuster.adjust(maker.ceSchemaName())).withSchema("id", Schema.STRING_SCHEMA).withSchema("source", Schema.STRING_SCHEMA).withSchema("specversion", Schema.STRING_SCHEMA).withSchema("type", Schema.STRING_SCHEMA).withSchema("time", Schema.STRING_SCHEMA).withSchema("datacontenttype", Schema.STRING_SCHEMA);
        if (dataSchema != null) {
            ceSchemaBuilder.withSchema("dataschema", Schema.STRING_SCHEMA);
        }
        if (this.extensionAttributesEnable) {
            ceSchemaBuilder.withSchema(CloudEventsConverter.adjustExtensionName("op"), Schema.STRING_SCHEMA);
            this.ceSchemaFromSchema(sourceSchema, ceSchemaBuilder, CloudEventsConverter::adjustExtensionName, false);
            this.ceSchemaFromSchema(TransactionMonitor.TRANSACTION_BLOCK_SCHEMA, ceSchemaBuilder, CloudEventsConverter::txExtensionName, true);
        }
        ceSchemaBuilder.withSchema("data", dataSchemaType);
        Schema ceSchema = ceSchemaBuilder.build();
        String ceId = this.metadataSource.id() == CloudEventsConverterConfig.MetadataSourceValue.GENERATE ? maker.ceId() : parser.id();
        String ceType = this.metadataSource.type() == CloudEventsConverterConfig.MetadataSourceValue.GENERATE ? maker.ceType() : parser.type();
        CEValueBuilder ceValueBuilder = CloudEventsConverter.withValue(ceSchema).withValue("id", ceId).withValue("source", maker.ceSource(source.getString("name"))).withValue("specversion", maker.ceSpecversion()).withValue("type", ceType).withValue("time", maker.ceTime()).withValue("datacontenttype", maker.ceDatacontenttype());
        if (dataSchema != null) {
            ceValueBuilder.withValue("dataschema", dataSchema);
        }
        if (this.extensionAttributesEnable) {
            ceValueBuilder.withValue(CloudEventsConverter.adjustExtensionName("op"), parser.op());
            this.ceValueFromStruct(source, sourceSchema, ceValueBuilder, CloudEventsConverter::adjustExtensionName);
            if (transaction != null) {
                this.ceValueFromStruct(transaction, TransactionMonitor.TRANSACTION_BLOCK_SCHEMA, ceValueBuilder, CloudEventsConverter::txExtensionName);
            }
        }
        ceValueBuilder.withValue("data", serializedData);
        return new SchemaAndValue(ceSchema, (Object)ceValueBuilder.build());
    }

    private void ceValueFromStruct(Struct struct, Schema schema, CEValueBuilder ceValueBuilder, Function<String, String> nameMapper) {
        for (Field field : schema.fields()) {
            Object value = struct.get(field);
            if (field.schema().type() == Schema.Type.INT64 && value != null) {
                value = String.valueOf((Long)value);
            }
            ceValueBuilder.withValue(nameMapper.apply(field.name()), value);
        }
    }

    private void ceSchemaFromSchema(Schema schema, CESchemaBuilder ceSchemaBuilder, Function<String, String> nameMapper, boolean alwaysOptional) {
        for (Field field : schema.fields()) {
            ceSchemaBuilder.withSchema(nameMapper.apply(field.name()), this.convertToCeExtensionSchema(field.schema(), alwaysOptional));
        }
    }

    private Schema convertToCeExtensionSchema(Schema schema, boolean alwaysOptional) {
        SchemaBuilder ceExtensionSchema;
        if (schema.type() == Schema.Type.BOOLEAN) {
            ceExtensionSchema = SchemaBuilder.bool();
        } else if (schema.type() == Schema.Type.INT8 || schema.type() == Schema.Type.INT16 || schema.type() == Schema.Type.INT16 || schema.type() == Schema.Type.INT32) {
            ceExtensionSchema = SchemaBuilder.int32();
        } else if (schema.type() == Schema.Type.STRING || schema.type() == Schema.Type.INT64) {
            ceExtensionSchema = SchemaBuilder.string();
        } else {
            throw new IllegalArgumentException("Source field of type " + schema.type() + " cannot be converted into CloudEvents extension attribute.");
        }
        if (alwaysOptional || schema.isOptional()) {
            ceExtensionSchema.optional();
        }
        return ceExtensionSchema.build();
    }

    private Schema convertToCeExtensionSchema(Schema schema) {
        return this.convertToCeExtensionSchema(schema, false);
    }

    private static CESchemaBuilder defineSchema() {
        return new CESchemaBuilder(){
            private final SchemaBuilder builder = SchemaBuilder.struct();

            @Override
            public CESchemaBuilder withName(String name) {
                this.builder.name(name);
                return this;
            }

            @Override
            public CESchemaBuilder withSchema(String fieldName, Schema fieldSchema) {
                this.builder.field(fieldName, fieldSchema);
                return this;
            }

            @Override
            public Schema build() {
                return this.builder.build();
            }
        };
    }

    private static CEValueBuilder withValue(final Schema schema) {
        return new CEValueBuilder(){
            private final Schema ceSchema;
            private final Struct ceValue;
            {
                this.ceSchema = schema;
                this.ceValue = new Struct(this.ceSchema);
            }

            @Override
            public CEValueBuilder withValue(String fieldName, Object value) {
                if (this.ceSchema.field(fieldName) == null) {
                    throw new DataException(fieldName + " is not a valid field name");
                }
                this.ceValue.put(fieldName, value);
                return this;
            }

            @Override
            public Struct build() {
                return this.ceValue;
            }
        };
    }

    static String adjustExtensionName(String original) {
        StringBuilder sb = new StringBuilder(EXTENSION_NAME_PREFIX);
        for (int i = 0; i != original.length(); ++i) {
            char c = original.charAt(i);
            if (!CloudEventsConverter.isValidExtensionNameCharacter(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static String txExtensionName(String name) {
        return CloudEventsConverter.adjustExtensionName(TX_ATTRIBUTE_PREFIX + name);
    }

    private static boolean isValidExtensionNameCharacter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    static {
        try {
            CONVERT_TO_CONNECT_METHOD = JsonConverter.class.getDeclaredMethod("convertToConnect", Schema.class, JsonNode.class, JsonConverterConfig.class);
            CONVERT_TO_CONNECT_METHOD.setAccessible(true);
            LOGGER.info("Using up-to-date JsonConverter implementation");
        }
        catch (NoSuchMethodException e) {
            try {
                CONVERT_TO_CONNECT_METHOD = JsonConverter.class.getDeclaredMethod("convertToConnect", Schema.class, JsonNode.class);
                CONVERT_TO_CONNECT_METHOD.setAccessible(true);
                LOGGER.info("Using legacy JsonConverter implementation");
            }
            catch (NoSuchMethodException ei) {
                throw new DataException((Throwable)ei);
            }
        }
        HashMap<String, CloudEventsProvider> tmp = new HashMap<String, CloudEventsProvider>();
        for (CloudEventsProvider provider : ServiceLoader.load(CloudEventsProvider.class)) {
            tmp.put(provider.getName(), provider);
        }
        PROVIDERS = Collections.unmodifiableMap(tmp);
    }

    public static interface CESchemaBuilder {
        public CESchemaBuilder withName(String var1);

        public CESchemaBuilder withSchema(String var1, Schema var2);

        public Schema build();
    }

    public static interface CEValueBuilder {
        public CEValueBuilder withValue(String var1, Object var2);

        public Struct build();
    }
}

