/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters;

import io.debezium.Module;
import io.debezium.config.Configuration;
import io.debezium.config.Instantiator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.ConverterConfig;
import org.apache.kafka.connect.storage.HeaderConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryDataConverter
implements Converter,
HeaderConverter,
Versioned {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinaryDataConverter.class);
    private static final ConfigDef CONFIG_DEF = ConverterConfig.newConfigDef();
    protected static final String DELEGATE_CONVERTER_TYPE = "delegate.converter.type";
    private Converter delegateConverter;

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void configure(Map<String, ?> configs) {
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        String converterTypeName = (String)configs.get(DELEGATE_CONVERTER_TYPE);
        if (converterTypeName != null) {
            this.delegateConverter = (Converter)Instantiator.getInstance(converterTypeName, null);
            this.delegateConverter.configure(Configuration.from(configs).subset(DELEGATE_CONVERTER_TYPE, true).asMap(), isKey);
        }
    }

    public byte[] fromConnectData(String topic, Schema schema, Object value) {
        if (schema != null && schema.type() != Schema.Type.BYTES) {
            this.assertDelegateProvided(topic, value);
            LOGGER.debug("Value is not of Schema.Type.BYTES, delegating to " + this.delegateConverter.getClass().getName());
            return this.delegateConverter.fromConnectData(topic, schema, value);
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof ByteBuffer) {
            return ((ByteBuffer)value).array();
        }
        if (value != null) {
            this.assertDelegateProvided(topic, value);
            LOGGER.debug("Value is not of Schema.Type.BYTES, delegating to " + this.delegateConverter.getClass().getName());
            return this.delegateConverter.fromConnectData(topic, schema, value);
        }
        return null;
    }

    public SchemaAndValue toConnectData(String topic, byte[] value) {
        return new SchemaAndValue(Schema.OPTIONAL_BYTES_SCHEMA, (Object)value);
    }

    public byte[] fromConnectHeader(String topic, String headerKey, Schema schema, Object value) {
        return this.fromConnectData(topic, schema, value);
    }

    public SchemaAndValue toConnectHeader(String topic, String headerKey, byte[] value) {
        return this.toConnectData(topic, value);
    }

    public void close() throws IOException {
    }

    public String version() {
        return Module.version();
    }

    private void assertDelegateProvided(String name, Object type) {
        if (this.delegateConverter == null) {
            throw new DataException("A " + name + " of type '" + type + "' requires a delegate.converter.type to be configured");
        }
    }

    static {
        CONFIG_DEF.define(DELEGATE_CONVERTER_TYPE, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "Specifies the delegate converter class");
    }
}

