/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import java.util.HashMap;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.transforms.ExtractField;
import org.apache.kafka.connect.transforms.Flatten;
import org.apache.kafka.connect.transforms.InsertField;

public class ConnectRecordUtil {
    private static final String UPDATE_DESCRIPTION = "updateDescription";

    public static <R extends ConnectRecord<R>> ExtractField<R> extractAfterDelegate() {
        return ConnectRecordUtil.extractValueDelegate("after");
    }

    public static <R extends ConnectRecord<R>> ExtractField<R> extractBeforeDelegate() {
        return ConnectRecordUtil.extractValueDelegate("before");
    }

    public static <R extends ConnectRecord<R>> ExtractField<R> extractUpdateDescriptionDelegate() {
        return ConnectRecordUtil.extractValueDelegate(UPDATE_DESCRIPTION);
    }

    public static <R extends ConnectRecord<R>> ExtractField<R> extractValueDelegate(String field) {
        ExtractField.Value extractField = new ExtractField.Value();
        HashMap<String, String> delegateConfig = new HashMap<String, String>();
        delegateConfig.put("field", field);
        extractField.configure(delegateConfig);
        return extractField;
    }

    public static <R extends ConnectRecord<R>> ExtractField<R> extractKeyDelegate(String field) {
        ExtractField.Key extractField = new ExtractField.Key();
        HashMap<String, String> delegateConfig = new HashMap<String, String>();
        delegateConfig.put("field", field);
        extractField.configure(delegateConfig);
        return extractField;
    }

    public static <R extends ConnectRecord<R>> InsertField<R> insertStaticValueDelegate(String field, String value) {
        InsertField.Value insertDelegate = new InsertField.Value();
        HashMap<String, String> delegateConfig = new HashMap<String, String>();
        delegateConfig.put("static.field", field);
        delegateConfig.put("static.value", value);
        insertDelegate.configure(delegateConfig);
        return insertDelegate;
    }

    public static <R extends ConnectRecord<R>> Flatten<R> flattenValueDelegate(String delimiter) {
        Flatten.Value recordFlattener = new Flatten.Value();
        HashMap<String, String> delegateConfig = new HashMap<String, String>();
        delegateConfig.put("delimiter", delimiter);
        recordFlattener.configure(delegateConfig);
        return recordFlattener;
    }
}

