/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters.spi;

import io.debezium.converters.spi.RecordParser;
import io.debezium.converters.spi.SerializerType;
import io.debezium.util.Collect;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.TimeZone;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public abstract class CloudEventsMaker {
    private static final String SCHEMA_URL_PATH = "/schemas/ids/";
    public static final String CLOUDEVENTS_SPECVERSION = "1.0";
    private final SerializerType dataContentType;
    private final String dataSchemaUriBase;
    private final Schema ceDataAttributeSchema;
    protected final RecordParser recordParser;
    static final Map<SerializerType, String> CONTENT_TYPE_NAME_MAP = Collect.hashMapOf(SerializerType.JSON, "application/json", SerializerType.AVRO, "application/avro");

    protected CloudEventsMaker(RecordParser parser, SerializerType contentType, String dataSchemaUriBase) {
        this.recordParser = parser;
        this.dataContentType = contentType;
        this.dataSchemaUriBase = dataSchemaUriBase;
        this.ceDataAttributeSchema = this.recordParser.dataSchema();
    }

    public abstract String ceId();

    public String ceSource(String logicalName) {
        return "/debezium/" + this.recordParser.connectorType() + "/" + logicalName;
    }

    public String ceSpecversion() {
        return CLOUDEVENTS_SPECVERSION;
    }

    public String ceType() {
        return "io.debezium.connector." + this.recordParser.connectorType() + ".DataChangeEvent";
    }

    public String ceDatacontenttype() {
        return CONTENT_TYPE_NAME_MAP.get((Object)this.dataContentType);
    }

    public String ceDataschemaUri(String schemaId) {
        return this.dataSchemaUriBase + SCHEMA_URL_PATH + schemaId;
    }

    public String ceTime() {
        long time = (Long)this.recordParser.getMetadata("ts_ms");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return formatter.format(time);
    }

    public Schema ceDataAttributeSchema() {
        return this.ceDataAttributeSchema;
    }

    public Struct ceDataAttribute() {
        return this.recordParser.data();
    }

    public String ceEnvelopeSchemaName() {
        return this.recordParser.getMetadata("name") + "." + this.recordParser.getMetadata("db") + ".CloudEvents.Envelope";
    }

    public static final class FieldName {
        public static final String ID = "id";
        public static final String SOURCE = "source";
        public static final String SPECVERSION = "specversion";
        public static final String TYPE = "type";
        public static final String DATACONTENTTYPE = "datacontenttype";
        public static final String DATASCHEMA = "dataschema";
        public static final String SUBJECT = "subject";
        public static final String TIME = "time";
        public static final String DATA = "data";
        public static final String SCHEMA_FIELD_NAME = "schema";
        public static final String PAYLOAD_FIELD_NAME = "payload";
    }
}

