/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.transforms.SmtManager;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaChangeEventFilter<R extends ConnectRecord<R>>
implements Transformation<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaChangeEventFilter.class);
    private static final Field SCHEMA_CHANGE_EVENT_EXCLUDE_LIST = Field.create("schema.change.event.exclude.list").withDisplayName("Schema change event exclude list").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Support filtering during DDL synchronization").required();
    private Set<SchemaChangeEvent.SchemaChangeEventType> excludeSchemaChangeEvents;
    private SmtManager<R> smtManager;

    public void configure(Map<String, ?> configs) {
        Configuration config = Configuration.from(configs);
        this.smtManager = new SmtManager(config);
        this.smtManager.validate(config, Field.setOf(SCHEMA_CHANGE_EVENT_EXCLUDE_LIST));
        String excludeSchemaChangeEvents = config.getString(SCHEMA_CHANGE_EVENT_EXCLUDE_LIST);
        this.excludeSchemaChangeEvents = Arrays.stream(excludeSchemaChangeEvents.split(",")).map(typeName -> SchemaChangeEvent.SchemaChangeEventType.valueOf(typeName)).collect(Collectors.toSet());
    }

    public R apply(R record) {
        if (record.value() == null || !this.smtManager.isValidSchemaChange(record)) {
            return record;
        }
        Struct recordValue = Requirements.requireStruct((Object)record.value(), (String)"Read schema change event to filter");
        List tableChanges = recordValue.getArray("tableChanges");
        if (tableChanges == null) {
            LOGGER.debug("Table changes is empty, excluded it.");
            return null;
        }
        SchemaChangeEvent.SchemaChangeEventType schemaChangeEventType = tableChanges.isEmpty() ? SchemaChangeEvent.SchemaChangeEventType.DATABASE : SchemaChangeEvent.SchemaChangeEventType.valueOf((String)((Struct)tableChanges.get(0)).get("type"));
        if (this.excludeSchemaChangeEvents.contains((Object)schemaChangeEventType)) {
            return record;
        }
        return null;
    }

    public ConfigDef config() {
        ConfigDef config = new ConfigDef();
        Field.group(config, null, SCHEMA_CHANGE_EVENT_EXCLUDE_LIST);
        return config;
    }

    public void close() {
    }
}

