/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.notification;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.pipeline.notification.Notification;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.pipeline.spi.Partition;
import io.debezium.pipeline.spi.SnapshotResult;
import io.debezium.spi.schema.DataCollectionId;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class InitialSnapshotNotificationService<P extends Partition, O extends OffsetContext> {
    public static final String INITIAL_SNAPSHOT = "Initial Snapshot";
    public static final String NONE = "<none>";
    public static final String CONNECTOR_NAME = "connector_name";
    public static final String STATUS = "status";
    private final NotificationService<P, O> notificationService;
    private final CommonConnectorConfig connectorConfig;

    public InitialSnapshotNotificationService(NotificationService<P, O> notificationService, CommonConnectorConfig connectorConfig) {
        this.notificationService = notificationService;
        this.connectorConfig = connectorConfig;
    }

    public <T extends DataCollectionId> void notifyStarted(P partition, OffsetContext offsetContext) {
        this.notificationService.notify(this.buildNotificationWith(SnapshotResult.SnapshotResultStatus.STARTED, Map.of()), Offsets.of(partition, offsetContext));
    }

    public <T extends DataCollectionId> void notifyAborted(P partition, OffsetContext offsetContext) {
        this.notificationService.notify(this.buildNotificationWith(SnapshotResult.SnapshotResultStatus.ABORTED, Map.of()), Offsets.of(partition, offsetContext));
    }

    public <T extends DataCollectionId> void notifyCompleted(P partition, OffsetContext offsetContext) {
        this.notificationService.notify(this.buildNotificationWith(SnapshotResult.SnapshotResultStatus.COMPLETED, Map.of()), Offsets.of(partition, offsetContext));
    }

    public void notifySkipped(P partition, OffsetContext offsetContext) {
        this.notificationService.notify(this.buildNotificationWith(SnapshotResult.SnapshotResultStatus.SKIPPED, Map.of()), Offsets.of(partition, offsetContext));
    }

    private <T extends DataCollectionId> Notification buildNotificationWith(SnapshotResult.SnapshotResultStatus type, Map<String, String> additionalData) {
        HashMap<String, String> fullMap = new HashMap<String, String>(additionalData);
        String connectorName = this.getConnectorName();
        fullMap.put(CONNECTOR_NAME, connectorName);
        return Notification.Builder.builder().withId(UUID.randomUUID().toString()).withAggregateType(INITIAL_SNAPSHOT).withType(type.name()).withAdditionalData(fullMap).build();
    }

    private String getConnectorName() {
        return this.connectorConfig.getLogicalName();
    }
}

