/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxUtils.class);
    private static final String JMX_OBJECT_NAME_FORMAT = "debezium.%s:type=%s,context=%s,server=%s";
    private static final int REGISTRATION_RETRIES = 12;
    private static final Duration REGISTRATION_RETRY_DELAY = Duration.ofSeconds(5L);

    public static void registerMXBean(ObjectName objectName, Object mxBean) {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            if (mBeanServer == null) {
                LOGGER.info("JMX not supported, bean '{}' not registered", (Object)objectName);
                return;
            }
            for (int attempt = 1; attempt <= 12; ++attempt) {
                try {
                    mBeanServer.registerMBean(mxBean, objectName);
                    break;
                }
                catch (InstanceAlreadyExistsException e) {
                    if (attempt < 12) {
                        LOGGER.warn("Unable to register metrics as an old set with the same name exists, retrying in {} (attempt {} out of {})", new Object[]{REGISTRATION_RETRY_DELAY, attempt, 12});
                        Metronome metronome = Metronome.sleeper(REGISTRATION_RETRY_DELAY, Clock.system());
                        metronome.pause();
                        continue;
                    }
                    LOGGER.error("Failed to register metrics MBean, metrics will not be available");
                    continue;
                }
            }
        }
        catch (InterruptedException | JMException e) {
            throw new RuntimeException("Unable to register the MBean '" + objectName + "'", e);
        }
    }

    public static void registerMXBean(Object mxBean, CommonConnectorConfig connectorConfig, String type, String context) {
        String jmxObjectName = JmxUtils.getManagementJmxObjectName(type, context, connectorConfig);
        try {
            ObjectName objectName = new ObjectName(jmxObjectName);
            JmxUtils.registerMXBean(objectName, mxBean);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Unable to register the MBean '" + jmxObjectName + "'", e);
        }
    }

    public static void unregisterMXBean(ObjectName objectName) {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            if (mBeanServer == null) {
                LOGGER.debug("JMX not supported, bean '{}' not registered", (Object)objectName);
                return;
            }
            try {
                mBeanServer.unregisterMBean(objectName);
            }
            catch (InstanceNotFoundException e) {
                LOGGER.info("Unable to unregister metrics MBean '{}' as it was not found", (Object)objectName);
            }
        }
        catch (JMException e) {
            throw new RuntimeException("Unable to unregister the MBean '" + objectName + "'", e);
        }
    }

    public static void unregisterMXBean(CommonConnectorConfig connectorConfig, String type, String context) {
        String jmxObjectName = JmxUtils.getManagementJmxObjectName(type, context, connectorConfig);
        try {
            ObjectName objectName = new ObjectName(jmxObjectName);
            JmxUtils.unregisterMXBean(objectName);
        }
        catch (MalformedObjectNameException e) {
            LOGGER.info("Unable to unregister metrics MBean '{}' as it was not found", (Object)jmxObjectName);
        }
    }

    private static String getManagementJmxObjectName(String type, String context, CommonConnectorConfig connectorConfig) {
        return String.format(JMX_OBJECT_NAME_FORMAT, connectorConfig.getContextName().toLowerCase(), type, context, connectorConfig.getLogicalName());
    }
}

