/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.notification;

import io.debezium.pipeline.notification.Notification;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.source.snapshot.incremental.DataCollection;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.pipeline.spi.Partition;
import io.debezium.spi.schema.DataCollectionId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.kafka.connect.errors.DataException;

public class IncrementalSnapshotNotificationService<P extends Partition, O extends OffsetContext> {
    public static final String INCREMENTAL_SNAPSHOT = "Incremental Snapshot";
    public static final String DATA_COLLECTIONS = "data_collections";
    public static final String CURRENT_COLLECTION_IN_PROGRESS = "current_collection_in_progress";
    public static final String MAXIMUM_KEY = "maximum_key";
    public static final String LAST_PROCESSED_KEY = "last_processed_key";
    public static final String NONE = "<none>";
    public static final String CONNECTOR_NAME = "connector_name";
    public static final String TOTAL_ROWS_SCANNED = "total_rows_scanned";
    public static final String LIST_DELIMITER = ",";
    private final NotificationService<P, O> notificationService;

    public IncrementalSnapshotNotificationService(NotificationService<P, O> notificationService) {
        this.notificationService = notificationService;
    }

    public <T extends DataCollectionId> void notifyStarted(IncrementalSnapshotContext<T> incrementalSnapshotContext, P partition, OffsetContext offsetContext) {
        String dataCollections = incrementalSnapshotContext.getDataCollections().stream().map(DataCollection::getId).map(DataCollectionId::identifier).collect(Collectors.joining(LIST_DELIMITER));
        this.notificationService.notify(this.buildNotificationWith(incrementalSnapshotContext, SnapshotStatus.STARTED, Map.of(DATA_COLLECTIONS, dataCollections), offsetContext), Offsets.of(partition, offsetContext));
    }

    public <T extends DataCollectionId> void notifyPaused(IncrementalSnapshotContext<T> incrementalSnapshotContext, P partition, OffsetContext offsetContext) {
        String dataCollections = incrementalSnapshotContext.getDataCollections().stream().map(DataCollection::getId).map(DataCollectionId::identifier).collect(Collectors.joining(LIST_DELIMITER));
        this.notificationService.notify(this.buildNotificationWith(incrementalSnapshotContext, SnapshotStatus.PAUSED, Map.of(DATA_COLLECTIONS, dataCollections), offsetContext), Offsets.of(partition, offsetContext));
    }

    public <T extends DataCollectionId> void notifyResumed(IncrementalSnapshotContext<T> incrementalSnapshotContext, P partition, OffsetContext offsetContext) {
        String dataCollections = incrementalSnapshotContext.getDataCollections().stream().map(DataCollection::getId).map(DataCollectionId::identifier).collect(Collectors.joining(LIST_DELIMITER));
        this.notificationService.notify(this.buildNotificationWith(incrementalSnapshotContext, SnapshotStatus.RESUMED, Map.of(DATA_COLLECTIONS, dataCollections), offsetContext), Offsets.of(partition, offsetContext));
    }

    public <T extends DataCollectionId> void notifyAborted(IncrementalSnapshotContext<T> incrementalSnapshotContext, P partition, OffsetContext offsetContext) {
        this.notificationService.notify(this.buildNotificationWith(incrementalSnapshotContext, SnapshotStatus.ABORTED, Map.of(), offsetContext), Offsets.of(partition, offsetContext));
    }

    public <T extends DataCollectionId> void notifyAborted(IncrementalSnapshotContext<T> incrementalSnapshotContext, P partition, OffsetContext offsetContext, List<String> dataCollectionIds) {
        this.notificationService.notify(this.buildNotificationWith(incrementalSnapshotContext, SnapshotStatus.ABORTED, Map.of(DATA_COLLECTIONS, String.join((CharSequence)LIST_DELIMITER, dataCollectionIds)), offsetContext), Offsets.of(partition, offsetContext));
    }

    public <T extends DataCollectionId> void notifyTableScanCompleted(IncrementalSnapshotContext<T> incrementalSnapshotContext, P partition, OffsetContext offsetContext, long totalRowsScanned) {
        String dataCollections = incrementalSnapshotContext.getDataCollections().stream().map(DataCollection::getId).map(DataCollectionId::identifier).collect(Collectors.joining(LIST_DELIMITER));
        this.notificationService.notify(this.buildNotificationWith(incrementalSnapshotContext, SnapshotStatus.TABLE_SCAN_COMPLETED, Map.of(DATA_COLLECTIONS, dataCollections, TOTAL_ROWS_SCANNED, String.valueOf(totalRowsScanned)), offsetContext), Offsets.of(partition, offsetContext));
    }

    public <T extends DataCollectionId> void notifyInProgress(IncrementalSnapshotContext<T> incrementalSnapshotContext, P partition, OffsetContext offsetContext) {
        String dataCollections = incrementalSnapshotContext.getDataCollections().stream().map(DataCollection::getId).map(DataCollectionId::identifier).collect(Collectors.joining(LIST_DELIMITER));
        this.notificationService.notify(this.buildNotificationWith(incrementalSnapshotContext, SnapshotStatus.IN_PROGRESS, Map.of(DATA_COLLECTIONS, dataCollections, CURRENT_COLLECTION_IN_PROGRESS, ((DataCollectionId)incrementalSnapshotContext.currentDataCollectionId().getId()).identifier(), MAXIMUM_KEY, incrementalSnapshotContext.maximumKey().orElse(new Object[0])[0].toString(), LAST_PROCESSED_KEY, incrementalSnapshotContext.chunkEndPosititon()[0].toString()), offsetContext), Offsets.of(partition, offsetContext));
    }

    public <T extends DataCollectionId> void notifyCompleted(IncrementalSnapshotContext<T> incrementalSnapshotContext, P partition, OffsetContext offsetContext) {
        this.notificationService.notify(this.buildNotificationWith(incrementalSnapshotContext, SnapshotStatus.COMPLETED, Map.of(), offsetContext), Offsets.of(partition, offsetContext));
    }

    private <T extends DataCollectionId> Notification buildNotificationWith(IncrementalSnapshotContext<T> incrementalSnapshotContext, SnapshotStatus type, Map<String, String> additionalData, OffsetContext offsetContext) {
        String connectorName;
        HashMap<String, String> fullMap = new HashMap<String, String>(additionalData);
        try {
            connectorName = offsetContext.getSourceInfo().getString("name");
        }
        catch (DataException e) {
            connectorName = NONE;
        }
        fullMap.put(CONNECTOR_NAME, connectorName);
        String id = incrementalSnapshotContext.getCorrelationId() != null ? incrementalSnapshotContext.getCorrelationId() : UUID.randomUUID().toString();
        return Notification.Builder.builder().withId(id).withAggregateType(INCREMENTAL_SNAPSHOT).withType(type.name()).withAdditionalData(fullMap).build();
    }

    public static enum SnapshotStatus {
        STARTED,
        PAUSED,
        RESUMED,
        ABORTED,
        IN_PROGRESS,
        TABLE_SCAN_COMPLETED,
        COMPLETED;

    }
}

