/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.signal;

import io.debezium.document.Array;
import io.debezium.document.Document;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.signal.AbstractSnapshotSignal;
import io.debezium.pipeline.signal.Signal;
import io.debezium.pipeline.spi.Partition;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Strings;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteSnapshot<P extends Partition>
extends AbstractSnapshotSignal<P> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteSnapshot.class);
    public static final String NAME = "execute-snapshot";
    private final EventDispatcher<P, ? extends DataCollectionId> dispatcher;

    public ExecuteSnapshot(EventDispatcher<P, ? extends DataCollectionId> dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public boolean arrived(Signal.Payload<P> signalPayload) throws InterruptedException {
        List<String> dataCollections = ExecuteSnapshot.getDataCollections(signalPayload.data);
        if (dataCollections == null) {
            return false;
        }
        AbstractSnapshotSignal.SnapshotType type = ExecuteSnapshot.getSnapshotType(signalPayload.data);
        Optional<String> additionalCondition = ExecuteSnapshot.getAdditionalCondition(signalPayload.data);
        Optional<String> surrogateKey = ExecuteSnapshot.getSurrogateKey(signalPayload.data);
        LOGGER.info("Requested '{}' snapshot of data collections '{}' with additional condition '{}' and surrogate key '{}'", new Object[]{type, dataCollections, additionalCondition.orElse("No condition passed"), surrogateKey.orElse("PK of table will be used")});
        switch (type) {
            case INCREMENTAL: {
                this.dispatcher.getIncrementalSnapshotChangeEventSource().addDataCollectionNamesToSnapshot(signalPayload.partition, dataCollections, additionalCondition, surrogateKey, signalPayload.offsetContext);
            }
        }
        return true;
    }

    public static List<String> getDataCollections(Document data) {
        Array dataCollectionsArray = data.getArray("data-collections");
        if (dataCollectionsArray == null || dataCollectionsArray.isEmpty()) {
            LOGGER.warn("Execute snapshot signal '{}' has arrived but the requested field '{}' is missing from data or is empty", (Object)data, (Object)"data-collections");
            return null;
        }
        return dataCollectionsArray.streamValues().map(v -> v.asString().trim()).collect(Collectors.toList());
    }

    public static Optional<String> getAdditionalCondition(Document data) {
        String additionalCondition = data.getString("additional-condition");
        return Strings.isNullOrBlank(additionalCondition) ? Optional.empty() : Optional.of(additionalCondition);
    }

    public static Optional<String> getSurrogateKey(Document data) {
        String surrogateKey = data.getString("surrogate-key");
        return Strings.isNullOrBlank(surrogateKey) ? Optional.empty() : Optional.of(surrogateKey);
    }
}

