/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Throwables {
    private static final Logger LOGGER = LoggerFactory.getLogger(Throwables.class);

    public static Throwable getRootCause(Throwable throwable) {
        Throwable cause;
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
        }
        return throwable;
    }

    public static void logErrorAndTraceRecord(Logger logger, Object record, String message, Throwable e) {
        logger.error(message, e);
        LOGGER.trace("Source of error is record '{}'", record);
    }

    public static void logErrorAndTraceRecord(Logger logger, Object record, String message, Object ... arguments) {
        logger.error(message, arguments);
        LOGGER.trace("Source of error is record '{}'", record);
    }
}

