/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum SerializerType {
    JSON,
    AVRO;

    private static final Map<String, SerializerType> NAME_TO_TYPE;
    private String name = this.name().toLowerCase(Locale.ROOT);

    public static SerializerType withName(String name) {
        if (name == null) {
            return null;
        }
        return NAME_TO_TYPE.get(name.toLowerCase(Locale.getDefault()));
    }

    public String getName() {
        return this.name;
    }

    static {
        SerializerType[] types = SerializerType.values();
        HashMap<String, SerializerType> nameToType = new HashMap<String, SerializerType>(types.length);
        for (SerializerType type : types) {
            nameToType.put(type.name, type);
        }
        NAME_TO_TYPE = Collections.unmodifiableMap(nameToType);
    }
}

