/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.kafka;

import io.debezium.kafka.ZookeeperServer;
import io.debezium.util.Testing;
import java.io.File;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ZookeeperServerTest {
    private ZookeeperServer server;
    private File dataDir;

    @Before
    public void beforeEach() {
        this.dataDir = Testing.Files.createTestingDirectory("zk");
        Testing.Files.delete(this.dataDir);
        this.server = new ZookeeperServer();
        this.server.setStateDirectory(this.dataDir);
    }

    @After
    public void afterEach() {
        Testing.Files.delete(this.dataDir);
    }

    @Test
    public void shouldStartServerAndRemoveData() throws Exception {
        Testing.debug("Running 1");
        this.server.startup();
        this.server.onEachDirectory(this::assertValidDataDirectory);
        this.server.shutdown(true);
        this.server.onEachDirectory(this::assertDoesNotExist);
    }

    @Test
    public void shouldStartServerAndLeaveData() throws Exception {
        Testing.debug("Running 2");
        this.server.startup();
        this.server.onEachDirectory(this::assertValidDataDirectory);
        this.server.shutdown(false);
        this.server.onEachDirectory(this::assertValidDataDirectory);
    }

    protected void assertValidDataDirectory(File dir) {
        Assertions.assertThat((boolean)dir.exists()).isTrue();
        Assertions.assertThat((boolean)dir.isDirectory()).isTrue();
        Assertions.assertThat((boolean)dir.canWrite()).isTrue();
        Assertions.assertThat((boolean)dir.canRead()).isTrue();
        Assertions.assertThat((boolean)Testing.Files.inTestDataDir(dir)).isTrue();
    }

    protected void assertDoesNotExist(File dir) {
        Assertions.assertThat((boolean)dir.exists()).isFalse();
    }
}

