/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.junit;

import io.debezium.junit.AnnotationBasedTestRule;
import io.debezium.junit.DatabaseVersionResolver;
import io.debezium.junit.EqualityCheck;
import io.debezium.junit.SkipLongRunning;
import io.debezium.junit.SkipOnOS;
import io.debezium.junit.SkipWhenDatabaseVersion;
import io.debezium.junit.SkipWhenDatabaseVersions;
import io.debezium.junit.SkipWhenKafkaVersion;
import io.debezium.util.Testing;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class SkipTestRule
extends AnnotationBasedTestRule {
    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Statement apply(Statement base, Description description) {
        skipLongRunningAnnotation = this.hasAnnotation(description, SkipLongRunning.class);
        if (skipLongRunningAnnotation != null) {
            skipLongRunning = System.getProperty("skipLongRunningTests");
            if (skipLongRunning == null) return SkipTestRule.emptyStatement(skipLongRunningAnnotation.value(), description);
            if (Boolean.valueOf(skipLongRunning).booleanValue()) {
                return SkipTestRule.emptyStatement(skipLongRunningAnnotation.value(), description);
            }
        }
        if ((skipOnOSAnnotation = this.hasAnnotation(description, SkipOnOS.class)) != null) {
            oses = skipOnOSAnnotation.value();
            osName = System.getProperty("os.name");
            if (osName != null && !osName.trim().isEmpty()) {
                for (String os : oses) {
                    if (!osName.toLowerCase().startsWith(os.toLowerCase())) continue;
                    return SkipTestRule.emptyStatement(skipOnOSAnnotation.description(), description);
                }
            }
        }
        if ((skipWhenKafkaVersionAnnotation = this.hasAnnotation(description, SkipWhenKafkaVersion.class)) != null) {
            kafkaVersion = skipWhenKafkaVersionAnnotation.value();
            check = skipWhenKafkaVersionAnnotation.check();
            try {
                stream = Testing.class.getResourceAsStream("/kafka/kafka-version.properties");
                try {
                    if (stream != null) {
                        properties = new Properties();
                        properties.load(stream);
                        version = properties.getProperty("version");
                        versionArray = version.split("\\.");
                        major = versionArray.length >= 1 ? Integer.parseInt(versionArray[0]) : 0;
                        minor = versionArray.length >= 2 ? Integer.parseInt(versionArray[1]) : 1;
                        patch = versionArray.length >= 3 ? Integer.parseInt(versionArray[2]) : 2;
                        switch (1.$SwitchMap$io$debezium$junit$EqualityCheck[check.ordinal()]) {
                            case 1: {
                                if (!kafkaVersion.isLessThan(major, minor, patch)) ** break;
                                var15_20 = SkipTestRule.emptyStatement(skipWhenKafkaVersionAnnotation.description(), description);
                                return var15_20;
                            }
                            case 2: {
                                if (!kafkaVersion.isLessThanOrEqualTo(major, minor, patch)) ** break;
                                var15_21 = SkipTestRule.emptyStatement(skipWhenKafkaVersionAnnotation.description(), description);
                                return var15_21;
                            }
                            case 3: {
                                if (!kafkaVersion.isEqualTo(major, minor, patch)) ** break;
                                var15_22 = SkipTestRule.emptyStatement(skipWhenKafkaVersionAnnotation.description(), description);
                                return var15_22;
                            }
                            case 4: {
                                if (!kafkaVersion.isGreaterThanOrEqualTo(major, minor, patch)) ** break;
                                var15_23 = SkipTestRule.emptyStatement(skipWhenKafkaVersionAnnotation.description(), description);
                                return var15_23;
                            }
                            case 5: {
                                if (!kafkaVersion.isGreaterThan(major, minor, patch)) ** break;
                                var15_24 = SkipTestRule.emptyStatement(skipWhenKafkaVersionAnnotation.description(), description);
                                return var15_24;
                            }
                        }
                    }
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (IOException var8_10) {
                // empty catch block
            }
        }
        if ((skipWhenDatabaseVersions = this.hasAnnotation(description, SkipWhenDatabaseVersions.class)) != null) {
            for (SkipWhenDatabaseVersion skipWhenDatabaseVersion : skipWhenDatabaseVersions.value()) {
                if (!this.isSkippedByDatabaseVersion(skipWhenDatabaseVersion)) continue;
                return SkipTestRule.emptyStatement(skipWhenDatabaseVersion.reason(), description);
            }
        }
        if ((skipWhenDatabaseVersion = this.hasAnnotation(description, SkipWhenDatabaseVersion.class)) == null) return base;
        if (this.isSkippedByDatabaseVersion(skipWhenDatabaseVersion) == false) return base;
        return SkipTestRule.emptyStatement(skipWhenDatabaseVersion.reason(), description);
    }

    private boolean isSkippedByDatabaseVersion(SkipWhenDatabaseVersion skipWhenDatabaseVersion) {
        EqualityCheck equalityCheck = skipWhenDatabaseVersion.check();
        int major = skipWhenDatabaseVersion.major();
        int minor = skipWhenDatabaseVersion.minor();
        int patch = skipWhenDatabaseVersion.patch();
        Reflections reflections = new Reflections("io.debezium", new Scanner[0]);
        Set resolvers = reflections.getSubTypesOf(DatabaseVersionResolver.class);
        Class resolverClass = resolvers.stream().findFirst().orElse(null);
        if (resolverClass != null) {
            try {
                DatabaseVersionResolver resolver = (DatabaseVersionResolver)resolverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                DatabaseVersionResolver.DatabaseVersion dbVersion = resolver.getVersion();
                if (dbVersion != null) {
                    switch (equalityCheck) {
                        case LESS_THAN: {
                            return dbVersion.isLessThan(major, minor, patch);
                        }
                        case LESS_THAN_OR_EQUAL: {
                            return dbVersion.isLessThanEqualTo(major, minor, patch);
                        }
                        case EQUAL: {
                            return dbVersion.isEqualTo(major, minor, patch);
                        }
                        case GREATER_THAN_OR_EQUAL: {
                            return dbVersion.isGreaterThanEqualTo(major, minor, patch);
                        }
                        case GREATER_THAN: {
                            return dbVersion.isGreaterThan(major, minor, patch);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

