/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.annotation.Immutable;
import io.debezium.function.Predicates;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnId;
import io.debezium.relational.Selectors;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Immutable
public class Key {
    private final Table table;
    private final KeyMapper keyMapper;

    private Key(Table table, KeyMapper keyMapper) {
        this.table = table;
        this.keyMapper = keyMapper;
    }

    public List<Column> keyColumns() {
        return this.keyMapper.getKeyKolumns(this.table);
    }

    public static class CustomKeyMapper {
        public static KeyMapper getInstance(String fullyQualifiedColumnNames, Selectors.TableIdToStringMapper tableIdMapper) {
            if (fullyQualifiedColumnNames == null) {
                return null;
            }
            String regexes = Arrays.asList(fullyQualifiedColumnNames.split(";")).stream().map(s -> s.split(":")).collect(ArrayList::new, (m, p) -> Arrays.asList(p[1].split(",")).forEach(c -> m.add(p[0] + "." + c)), ArrayList::addAll).stream().collect(Collectors.joining(","));
            Predicate<ColumnId> delegate = Predicates.includes(regexes, ColumnId::toString);
            return table -> {
                List candidates = table.columns().stream().filter(c -> {
                    TableId tableId = table.id();
                    if (tableIdMapper == null) {
                        return delegate.test(new ColumnId(tableId.catalog(), tableId.schema(), tableId.table(), c.name()));
                    }
                    return delegate.test(new ColumnId(tableId.catalog(), tableId.schema(), tableId.table(), c.name())) || delegate.test(new ColumnId(new TableId(tableId.catalog(), tableId.schema(), tableId.table(), tableIdMapper), c.name()));
                }).collect(Collectors.toList());
                return candidates.isEmpty() ? table.primaryKeyColumns() : candidates;
            };
        }
    }

    private static class IdentityKeyMapper {
        private IdentityKeyMapper() {
        }

        public static KeyMapper getInstance() {
            return table -> table.primaryKeyColumns();
        }
    }

    @FunctionalInterface
    public static interface KeyMapper {
        public List<Column> getKeyKolumns(Table var1);
    }

    public static class Builder {
        private final Table table;
        private KeyMapper keyMapper = IdentityKeyMapper.getInstance();

        public Builder(Table table) {
            this.table = table;
        }

        public Builder customKeyMapper(KeyMapper customKeyMapper) {
            if (customKeyMapper != null) {
                this.keyMapper = customKeyMapper;
            }
            return this;
        }

        public Key build() {
            return new Key(this.table, this.keyMapper);
        }
    }
}

