/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.metrics;

import io.debezium.annotation.ThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.common.CdcSourceTaskContext;
import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;

@ThreadSafe
public abstract class Metrics {
    private final ObjectName name;

    protected Metrics(CdcSourceTaskContext taskContext, String contextName) {
        this.name = this.metricName(taskContext.getConnectorType(), taskContext.getConnectorName(), contextName);
    }

    protected Metrics(CommonConnectorConfig connectorConfig, String contextName) {
        this.name = this.metricName(connectorConfig.getContextName(), connectorConfig.getLogicalName(), contextName);
    }

    public synchronized void register(Logger logger) {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            if (mBeanServer == null) {
                logger.info("JMX not supported, bean '{}' not registered");
                return;
            }
            mBeanServer.registerMBean(this, this.name);
        }
        catch (JMException e) {
            logger.warn("Error while register the MBean '{}': {}", (Object)this.name, (Object)e.getMessage());
        }
    }

    public final void unregister(Logger logger) {
        if (this.name != null) {
            try {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mBeanServer == null) {
                    logger.debug("JMX not supported, bean '{}' not registered");
                    return;
                }
                mBeanServer.unregisterMBean(this.name);
            }
            catch (JMException e) {
                logger.error("Unable to unregister the MBean '{}'", (Object)this.name);
            }
        }
    }

    public ObjectName metricName(String connectorType, String connectorName, String contextName) {
        String metricName = "debezium." + connectorType.toLowerCase() + ":type=connector-metrics,context=" + contextName + ",server=" + connectorName;
        try {
            return new ObjectName(metricName);
        }
        catch (MalformedObjectNameException e) {
            throw new ConnectException("Invalid metric name '" + metricName + "'");
        }
    }
}

