/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.config;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.relational.history.KafkaDatabaseHistory;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.apache.kafka.common.config.ConfigDef;

public abstract class CommonConnectorConfig {
    public static final int DEFAULT_MAX_QUEUE_SIZE = 8192;
    public static final int DEFAULT_MAX_BATCH_SIZE = 2048;
    public static final long DEFAULT_POLL_INTERVAL_MILLIS = 500L;
    public static final String DATABASE_CONFIG_PREFIX = "database.";
    public static final Field TOMBSTONES_ON_DELETE = Field.create("tombstones.on.delete").withDisplayName("Change the behaviour of Debezium with regards to delete operations").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(true).withValidation(Field::isBoolean).withDescription("Whether delete operations should be represented by a delete event and a subsquenttombstone event (true) or only by a delete event (false). Emitting the tombstone event (the default behavior) allows Kafka to completely delete all events pertaining to the given key once the source record got deleted.");
    public static final Field MAX_QUEUE_SIZE = Field.create("max.queue.size").withDisplayName("Change event buffer size").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Maximum size of the queue for change events read from the database log but not yet recorded or forwarded. Defaults to 8192, and should always be larger than the maximum batch size.").withDefault(8192).withValidation(CommonConnectorConfig::validateMaxQueueSize);
    public static final Field MAX_BATCH_SIZE = Field.create("max.batch.size").withDisplayName("Change event batch size").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Maximum size of each batch of source records. Defaults to 2048.").withDefault(2048).withValidation(Field::isPositiveInteger);
    public static final Field POLL_INTERVAL_MS = Field.create("poll.interval.ms").withDisplayName("Poll interval (ms)").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Frequency in milliseconds to wait for new change events to appear after receiving no events. Defaults to 500ms.").withDefault(500L).withValidation(Field::isPositiveInteger);
    public static final Field SNAPSHOT_DELAY_MS = Field.create("snapshot.delay.ms").withDisplayName("Snapshot Delay (milliseconds)").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("The number of milliseconds to delay before a snapshot will begin.").withDefault(0L).withValidation(Field::isNonNegativeLong);
    public static final Field SNAPSHOT_FETCH_SIZE = Field.create("snapshot.fetch.size").withDisplayName("Snapshot fetch size").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The maximum number of records that should be loaded into memory while performing a snapshot").withValidation(Field::isNonNegativeInteger);
    public static final Field SOURCE_STRUCT_MAKER_VERSION = Field.create("source.struct.version").withDisplayName("Source struct maker version").withEnum(Version.class, Version.V2).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("A version of the format of the publicly visible source part in the message").withValidation(Field::isClassName);
    public static final Field SANITIZE_FIELD_NAMES = Field.create("sanitize.field.names").withDisplayName("Sanitize field names to adhere to Avro naming conventions").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Whether field names will be sanitized to Avro naming conventions").withDefault(Boolean.FALSE);
    public static final Field EVENT_PROCESSING_FAILURE_HANDLING_MODE = Field.create("event.processing.failure.handling.mode").withDisplayName("Event deserialization failure handling").withEnum(EventProcessingFailureHandlingMode.class, EventProcessingFailureHandlingMode.FAIL).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify how failures during processing of events (i.e. when encountering a corrupted event) should be handled, including:'fail' (the default) an exception indicating the problematic event and its position is raised, causing the connector to be stopped; 'warn' the problematic event and its position will be logged and the event will be skipped;'ignore' the problematic event will be skipped.");
    private final Configuration config;
    private final boolean emitTombstoneOnDelete;
    private final int maxQueueSize;
    private final int maxBatchSize;
    private final Duration pollInterval;
    private final String logicalName;
    private final String heartbeatTopicsPrefix;
    private final Duration snapshotDelayMs;
    private final int snapshotFetchSize;
    private final SourceInfoStructMaker<? extends AbstractSourceInfo> sourceInfoStructMaker;
    private final boolean sanitizeFieldNames;
    private final EventProcessingFailureHandlingMode eventProcessingFailureHandlingMode;

    protected CommonConnectorConfig(Configuration config, String logicalName, int defaultSnapshotFetchSize) {
        this.config = config;
        this.emitTombstoneOnDelete = config.getBoolean(TOMBSTONES_ON_DELETE);
        this.maxQueueSize = config.getInteger(MAX_QUEUE_SIZE);
        this.maxBatchSize = config.getInteger(MAX_BATCH_SIZE);
        this.pollInterval = config.getDuration(POLL_INTERVAL_MS, ChronoUnit.MILLIS);
        this.logicalName = logicalName;
        this.heartbeatTopicsPrefix = config.getString(Heartbeat.HEARTBEAT_TOPICS_PREFIX);
        this.snapshotDelayMs = Duration.ofMillis(config.getLong(SNAPSHOT_DELAY_MS));
        this.snapshotFetchSize = config.getInteger(SNAPSHOT_FETCH_SIZE, defaultSnapshotFetchSize);
        this.sourceInfoStructMaker = this.getSourceInfoStructMaker(Version.parse(config.getString(SOURCE_STRUCT_MAKER_VERSION)));
        this.sanitizeFieldNames = config.getBoolean(SANITIZE_FIELD_NAMES) || CommonConnectorConfig.isUsingAvroConverter(config);
        this.eventProcessingFailureHandlingMode = EventProcessingFailureHandlingMode.parse(config.getString(EVENT_PROCESSING_FAILURE_HANDLING_MODE));
    }

    public Configuration getConfig() {
        return this.config;
    }

    public boolean isEmitTombstoneOnDelete() {
        return this.emitTombstoneOnDelete;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public Duration getPollInterval() {
        return this.pollInterval;
    }

    public String getLogicalName() {
        return this.logicalName;
    }

    public abstract String getContextName();

    public String getHeartbeatTopicsPrefix() {
        return this.heartbeatTopicsPrefix;
    }

    public Duration getSnapshotDelay() {
        return this.snapshotDelayMs;
    }

    public int getSnapshotFetchSize() {
        return this.snapshotFetchSize;
    }

    public EventProcessingFailureHandlingMode getEventProcessingFailureHandlingMode() {
        return this.eventProcessingFailureHandlingMode;
    }

    public <T extends AbstractSourceInfo> SourceInfoStructMaker<T> getSourceInfoStructMaker() {
        return this.sourceInfoStructMaker;
    }

    public boolean getSanitizeFieldNames() {
        return this.sanitizeFieldNames;
    }

    private static int validateMaxQueueSize(Configuration config, Field field, Field.ValidationOutput problems) {
        int maxQueueSize = config.getInteger(field);
        int maxBatchSize = config.getInteger(MAX_BATCH_SIZE);
        int count = 0;
        if (maxQueueSize <= 0) {
            problems.accept(field, maxQueueSize, "A positive queue size is required");
            ++count;
        }
        if (maxQueueSize <= maxBatchSize) {
            problems.accept(field, maxQueueSize, "Must be larger than the maximum batch size");
            ++count;
        }
        return count;
    }

    private static boolean isUsingAvroConverter(Configuration config) {
        String avroConverter = "io.confluent.connect.avro.AvroConverter";
        String keyConverter = config.getString("key.converter");
        String valueConverter = config.getString("value.converter");
        return "io.confluent.connect.avro.AvroConverter".equals(keyConverter) || "io.confluent.connect.avro.AvroConverter".equals(valueConverter);
    }

    protected static int validateServerNameIsDifferentFromHistoryTopicName(Configuration config, Field field, Field.ValidationOutput problems) {
        String historyTopicName;
        String serverName = config.getString(field);
        if (Objects.equals(serverName, historyTopicName = config.getString(KafkaDatabaseHistory.TOPIC))) {
            problems.accept(field, serverName, "Must not have the same value as " + KafkaDatabaseHistory.TOPIC.name());
            return 1;
        }
        return 0;
    }

    protected abstract SourceInfoStructMaker<?> getSourceInfoStructMaker(Version var1);

    public static enum EventProcessingFailureHandlingMode implements EnumeratedValue
    {
        SKIP("skip"),
        WARN("warn"),
        FAIL("fail"),
        IGNORE("ignore");

        public static final String OBSOLETE_NAME_FOR_SKIP_FAILURE_HANDLING = "ignore";
        private final String value;

        private EventProcessingFailureHandlingMode(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static EventProcessingFailureHandlingMode parse(String value) {
            if (value == null) {
                return null;
            }
            if (OBSOLETE_NAME_FOR_SKIP_FAILURE_HANDLING.equals(value = value.trim())) {
                return SKIP;
            }
            for (EventProcessingFailureHandlingMode option : EventProcessingFailureHandlingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }
    }

    public static enum Version implements EnumeratedValue
    {
        V1("v1"),
        V2("v2");

        private final String value;

        private Version(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static Version parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (Version option : Version.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static Version parse(String value, String defaultValue) {
            Version mode = Version.parse(value);
            if (mode == null && defaultValue != null) {
                mode = Version.parse(defaultValue);
            }
            return mode;
        }
    }
}

