/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.relational.RelationalTableFilters;
import io.debezium.relational.Selectors;
import io.debezium.relational.Tables;
import org.apache.kafka.common.config.ConfigDef;

public abstract class RelationalDatabaseConnectorConfig
extends CommonConnectorConfig {
    public static final Field TABLE_WHITELIST = Field.create("table.whitelist").withDisplayName("Included tables").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::isListOfRegex).withDescription("The tables for which changes are to be captured");
    public static final Field TABLE_BLACKLIST = Field.create("table.blacklist").withDisplayName("Excluded tables").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(Field::isListOfRegex, RelationalDatabaseConnectorConfig::validateTableBlacklist).withInvisibleRecommender();
    public static final Field TABLE_IGNORE_BUILTIN = Field.create("table.ignore.builtin").withDisplayName("Ignore system databases").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(true).withValidation(Field::isBoolean).withDescription("Flag specifying whether built-in tables should be ignored.");
    public static final Field COLUMN_BLACKLIST = Field.create("column.blacklist").withDisplayName("Exclude Columns").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("");
    public static final Field DECIMAL_HANDLING_MODE = Field.create("decimal.handling.mode").withDisplayName("Decimal Handling").withEnum(DecimalHandlingMode.class, DecimalHandlingMode.PRECISE).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify how DECIMAL and NUMERIC columns should be represented in change events, including:'precise' (the default) uses java.math.BigDecimal to represent values, which are encoded in the change events using a binary representation and Kafka Connect's 'org.apache.kafka.connect.data.Decimal' type; 'string' uses string to represent values; 'double' represents values using Java's 'double', which may not offer the precision but will be far easier to use in consumers.");
    private final RelationalTableFilters tableFilters;

    protected RelationalDatabaseConnectorConfig(Configuration config, String logicalName, Tables.TableFilter systemTablesFilter, Selectors.TableIdToStringMapper tableIdMapper) {
        super(config, logicalName);
        this.tableFilters = systemTablesFilter != null && tableIdMapper != null ? new RelationalTableFilters(config, systemTablesFilter, tableIdMapper) : null;
    }

    public RelationalTableFilters getTableFilters() {
        return this.tableFilters;
    }

    public JdbcValueConverters.DecimalMode getDecimalMode() {
        return DecimalHandlingMode.parse(this.getConfig().getString(DECIMAL_HANDLING_MODE)).asDecimalMode();
    }

    private static int validateTableBlacklist(Configuration config, Field field, Field.ValidationOutput problems) {
        String whitelist = config.getString(TABLE_WHITELIST);
        String blacklist = config.getString(TABLE_BLACKLIST);
        if (whitelist != null && blacklist != null) {
            problems.accept(TABLE_BLACKLIST, blacklist, "Table whitelist is already specified");
            return 1;
        }
        return 0;
    }

    public static enum DecimalHandlingMode implements EnumeratedValue
    {
        PRECISE("precise"),
        STRING("string"),
        DOUBLE("double");

        private final String value;

        private DecimalHandlingMode(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public JdbcValueConverters.DecimalMode asDecimalMode() {
            switch (this) {
                case DOUBLE: {
                    return JdbcValueConverters.DecimalMode.DOUBLE;
                }
                case STRING: {
                    return JdbcValueConverters.DecimalMode.STRING;
                }
            }
            return JdbcValueConverters.DecimalMode.PRECISE;
        }

        public static DecimalHandlingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (DecimalHandlingMode option : DecimalHandlingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static DecimalHandlingMode parse(String value, String defaultValue) {
            DecimalHandlingMode mode = DecimalHandlingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = DecimalHandlingMode.parse(defaultValue);
            }
            return mode;
        }
    }
}

