/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.schema;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.schema.DataCollectionId;

public class TopicSelector<I extends DataCollectionId> {
    private final String prefix;
    private final String heartbeatPrefix;
    private final String delimiter;
    private final DataCollectionTopicNamer<I> dataCollectionTopicNamer;

    private TopicSelector(String prefix, String heartbeatPrefix, String delimiter, DataCollectionTopicNamer<I> dataCollectionTopicNamer) {
        this.prefix = prefix;
        this.heartbeatPrefix = heartbeatPrefix;
        this.delimiter = delimiter;
        this.dataCollectionTopicNamer = dataCollectionTopicNamer;
    }

    public static <I extends DataCollectionId> TopicSelector<I> defaultSelector(String prefix, String heartbeatPrefix, String delimiter, DataCollectionTopicNamer<I> dataCollectionTopicNamer) {
        return new TopicSelector<I>(prefix, heartbeatPrefix, delimiter, dataCollectionTopicNamer);
    }

    public static <I extends DataCollectionId> TopicSelector<I> defaultSelector(CommonConnectorConfig connectorConfig, DataCollectionTopicNamer<I> dataCollectionTopicNamer) {
        String prefix = connectorConfig.getLogicalName();
        String heartbeatTopicsPrefix = connectorConfig.getHeartbeatTopicsPrefix();
        String delimiter = ".";
        return new TopicSelector<I>(prefix, heartbeatTopicsPrefix, delimiter, dataCollectionTopicNamer);
    }

    public String topicNameFor(I id) {
        return this.dataCollectionTopicNamer.topicNameFor(id, this.prefix, this.delimiter);
    }

    public String getPrimaryTopic() {
        return this.prefix;
    }

    public String getHeartbeatTopic() {
        return String.join((CharSequence)this.delimiter, this.heartbeatPrefix, this.prefix);
    }

    @FunctionalInterface
    public static interface DataCollectionTopicNamer<I extends DataCollectionId> {
        public String topicNameFor(I var1, String var2, String var3);
    }
}

