/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.mapping;

import io.debezium.annotation.Immutable;
import io.debezium.config.Configuration;
import io.debezium.function.Predicates;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnId;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.ValueConverter;
import io.debezium.relational.mapping.ColumnMapper;
import io.debezium.relational.mapping.MaskStrings;
import io.debezium.relational.mapping.TruncateStrings;
import io.debezium.util.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.kafka.connect.errors.ConnectException;

@Immutable
public class ColumnMappers {
    private final List<MapperRule> rules;

    public static Builder create() {
        return new Builder();
    }

    private ColumnMappers(List<MapperRule> rules) {
        assert (rules != null);
        this.rules = new ArrayList<MapperRule>(rules);
    }

    public ValueConverter mappingConverterFor(Table table, Column column) {
        return this.mappingConverterFor(table.id(), column);
    }

    public ValueConverter mappingConverterFor(TableId tableId, Column column) {
        ColumnMapper mapper = this.mapperFor(tableId, column);
        return mapper != null ? mapper.create(column) : null;
    }

    public ColumnMapper mapperFor(TableId tableId, Column column) {
        ColumnId id = new ColumnId(tableId, column.name());
        Optional<MapperRule> matchingRule = this.rules.stream().filter(rule -> rule.matches(id)).findFirst();
        if (matchingRule.isPresent()) {
            return matchingRule.get().mapper;
        }
        return null;
    }

    protected static ColumnMapper instantiateMapper(Class<ColumnMapper> clazz, Configuration config) {
        try {
            ColumnMapper mapper = clazz.newInstance();
            if (config != null) {
                mapper.initialize(config);
            }
            return mapper;
        }
        catch (InstantiationException e) {
            throw new ConnectException("Unable to instantiate column mapper class " + clazz.getName() + ": " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ConnectException("Unable to access column mapper class " + clazz.getName() + ": " + e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            throw new ConnectException("Unable to initialize the column mapper class " + clazz.getName() + ": " + e.getMessage(), e);
        }
    }

    @Immutable
    protected static final class MapperRule {
        protected final Predicate<ColumnId> predicate;
        protected final ColumnMapper mapper;

        protected MapperRule(Predicate<ColumnId> predicate, ColumnMapper mapper) {
            this.predicate = predicate;
            this.mapper = mapper;
        }

        protected boolean matches(ColumnId id) {
            return this.predicate.test(id);
        }
    }

    public static class Builder {
        private final List<MapperRule> rules = new ArrayList<MapperRule>();

        public Builder map(String fullyQualifiedColumnNames, ColumnMapper mapper) {
            Predicate<ColumnId> columnMatcher = Predicates.includes(fullyQualifiedColumnNames, ColumnId::toString);
            this.rules.add(new MapperRule(columnMatcher, mapper));
            return this;
        }

        public Builder map(String fullyQualifiedColumnNames, Class<ColumnMapper> mapperClass) {
            return this.map(fullyQualifiedColumnNames, mapperClass, null);
        }

        public Builder map(String fullyQualifiedColumnNames, Class<ColumnMapper> mapperClass, Configuration config) {
            return this.map(fullyQualifiedColumnNames, ColumnMappers.instantiateMapper(mapperClass, config));
        }

        public Builder truncateStrings(String fullyQualifiedColumnNames, int maxLength) {
            return this.map(fullyQualifiedColumnNames, new TruncateStrings(maxLength));
        }

        public Builder maskStrings(String fullyQualifiedColumnNames, int numberOfChars) {
            return this.maskStrings(fullyQualifiedColumnNames, numberOfChars, '*');
        }

        public Builder maskStrings(String fullyQualifiedColumnNames, int numberOfChars, char maskChar) {
            return this.maskStrings(fullyQualifiedColumnNames, Strings.createString(maskChar, numberOfChars));
        }

        public Builder maskStrings(String fullyQualifiedColumnNames, String maskValue) {
            return this.map(fullyQualifiedColumnNames, new MaskStrings(maskValue));
        }

        public Builder map(String fullyQualifiedColumnNames, String mapperClassName) {
            return this.map(fullyQualifiedColumnNames, mapperClassName, null);
        }

        public Builder map(String fullyQualifiedColumnNames, String mapperClassName, Configuration config) {
            Class<?> mapperClass = null;
            if (mapperClassName != null) {
                try {
                    mapperClass = this.getClass().getClassLoader().loadClass(mapperClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new ConnectException("Unable to find column mapper class " + mapperClassName + ": " + e.getMessage(), (Throwable)e);
                }
                catch (ClassCastException e) {
                    throw new ConnectException("Column mapper class must implement " + ColumnMapper.class + " but does not: " + e.getMessage(), (Throwable)e);
                }
            }
            return this.map(fullyQualifiedColumnNames, mapperClass, config);
        }

        public ColumnMappers build() {
            return new ColumnMappers(this.rules);
        }
    }
}

