/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.annotation.Immutable;
import io.debezium.function.Predicates;
import io.debezium.relational.ColumnId;
import io.debezium.relational.TableId;
import java.util.function.Predicate;

@Immutable
public class Selectors {
    public static DatabaseSelectionPredicateBuilder databaseSelector() {
        return new DatabaseSelectionPredicateBuilder();
    }

    public static TableSelectionPredicateBuilder tableSelector() {
        return new TableSelectionPredicateBuilder();
    }

    public static Predicate<ColumnId> excludeColumns(String fullyQualifiedTableNames) {
        return Predicates.excludes(fullyQualifiedTableNames, ColumnId::toString);
    }

    public static class TableSelectionPredicateBuilder {
        private Predicate<String> dbInclusions;
        private Predicate<String> dbExclusions;
        private Predicate<TableId> tableInclusions;
        private Predicate<TableId> tableExclusions;

        public TableSelectionPredicateBuilder includeDatabases(String databaseNames) {
            this.dbInclusions = databaseNames == null || databaseNames.trim().isEmpty() ? null : Predicates.includes(databaseNames);
            return this;
        }

        public TableSelectionPredicateBuilder excludeDatabases(String databaseNames) {
            this.dbExclusions = databaseNames == null || databaseNames.trim().isEmpty() ? null : Predicates.excludes(databaseNames);
            return this;
        }

        public TableSelectionPredicateBuilder includeTables(String fullyQualifiedTableNames) {
            this.tableInclusions = fullyQualifiedTableNames == null || fullyQualifiedTableNames.trim().isEmpty() ? null : Predicates.includes(fullyQualifiedTableNames, TableId::toString);
            return this;
        }

        public TableSelectionPredicateBuilder excludeTables(String fullyQualifiedTableNames) {
            this.tableExclusions = fullyQualifiedTableNames == null || fullyQualifiedTableNames.trim().isEmpty() ? null : Predicates.excludes(fullyQualifiedTableNames, TableId::toString);
            return this;
        }

        public Predicate<TableId> build() {
            Predicate<String> dbFilter;
            Predicate<TableId> tableFilter = this.tableInclusions != null ? this.tableInclusions : this.tableExclusions;
            Predicate<String> predicate = dbFilter = this.dbInclusions != null ? this.dbInclusions : this.dbExclusions;
            if (dbFilter != null) {
                if (tableFilter != null) {
                    return id -> dbFilter.test(id.catalog()) && tableFilter.test((TableId)id);
                }
                return id -> dbFilter.test(id.catalog());
            }
            if (tableFilter != null) {
                return tableFilter;
            }
            return id -> true;
        }
    }

    public static class DatabaseSelectionPredicateBuilder {
        private Predicate<String> dbInclusions;
        private Predicate<String> dbExclusions;

        public DatabaseSelectionPredicateBuilder includeDatabases(String databaseNames) {
            this.dbInclusions = databaseNames == null || databaseNames.trim().isEmpty() ? null : Predicates.includes(databaseNames);
            return this;
        }

        public DatabaseSelectionPredicateBuilder excludeDatabases(String databaseNames) {
            this.dbExclusions = databaseNames == null || databaseNames.trim().isEmpty() ? null : Predicates.excludes(databaseNames);
            return this;
        }

        public Predicate<String> build() {
            Predicate<String> dbFilter = this.dbInclusions != null ? this.dbInclusions : this.dbExclusions;
            return dbFilter != null ? dbFilter : id -> true;
        }
    }
}

