/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.annotation.ThreadSafe;
import io.debezium.function.Predicates;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnId;
import io.debezium.relational.Table;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.TableImpl;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.util.Collect;
import io.debezium.util.FunctionalReadWriteLock;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;

@ThreadSafe
public final class Tables {
    private final FunctionalReadWriteLock lock = FunctionalReadWriteLock.reentrant();
    private final TablesById tablesByTableId;
    private final TableIds changes;
    private final boolean tableIdCaseInsensitive;

    public Tables(boolean tableIdCaseInsensitive) {
        this.tableIdCaseInsensitive = tableIdCaseInsensitive;
        this.tablesByTableId = new TablesById(tableIdCaseInsensitive);
        this.changes = new TableIds(tableIdCaseInsensitive);
    }

    public Tables() {
        this(false);
    }

    protected Tables(Tables other, boolean tableIdCaseInsensitive) {
        this(tableIdCaseInsensitive);
        this.tablesByTableId.putAll(other.tablesByTableId);
    }

    public void clear() {
        this.lock.write(() -> {
            this.tablesByTableId.clear();
            this.changes.clear();
        });
    }

    public Tables clone() {
        return new Tables(this, this.tableIdCaseInsensitive);
    }

    public int size() {
        return this.lock.read(this.tablesByTableId::size);
    }

    public Set<TableId> drainChanges() {
        return this.lock.write(() -> {
            Set<TableId> result = this.changes.toSet();
            this.changes.clear();
            return result;
        });
    }

    public Table overwriteTable(TableId tableId, List<Column> columnDefs, List<String> primaryKeyColumnNames, String defaultCharsetName) {
        return this.lock.write(() -> {
            TableImpl updated = new TableImpl(tableId, columnDefs, primaryKeyColumnNames, defaultCharsetName);
            TableImpl existing = this.tablesByTableId.get(tableId);
            if (existing == null || !existing.equals(updated)) {
                this.changes.add(tableId);
                this.tablesByTableId.put(tableId, updated);
            }
            return this.tablesByTableId.get(tableId);
        });
    }

    public Table overwriteTable(Table table) {
        return this.lock.write(() -> {
            TableImpl updated = new TableImpl(table);
            try {
                Table table2 = this.tablesByTableId.put(updated.id(), updated);
                return table2;
            }
            finally {
                this.changes.add(updated.id());
            }
        });
    }

    public void removeTablesForDatabase(String schemaName) {
        this.removeTablesForDatabase(schemaName, null);
    }

    public void removeTablesForDatabase(String catalogName, String schemaName) {
        this.lock.write(() -> this.tablesByTableId.entrySet().removeIf(tableIdTableEntry -> {
            TableId tableId = (TableId)tableIdTableEntry.getKey();
            boolean equalCatalog = Objects.equals(catalogName, tableId.catalog());
            boolean equalSchema = Objects.equals(schemaName, tableId.schema());
            return equalSchema && equalCatalog;
        }));
    }

    public Table renameTable(TableId existingTableId, TableId newTableId) {
        return this.lock.write(() -> {
            Table existing = this.forTable(existingTableId);
            if (existing == null) {
                return null;
            }
            this.tablesByTableId.remove(existing.id());
            TableImpl updated = new TableImpl(newTableId, existing.columns(), existing.primaryKeyColumnNames(), existing.defaultCharsetName());
            try {
                Table table = this.tablesByTableId.put(updated.id(), updated);
                return table;
            }
            finally {
                this.changes.add(existingTableId);
                this.changes.add(updated.id());
            }
        });
    }

    public Table updateTable(TableId tableId, Function<Table, Table> changer) {
        return this.lock.write(() -> {
            TableImpl existing = this.tablesByTableId.get(tableId);
            Table updated = (Table)changer.apply(existing);
            if (updated != existing) {
                this.tablesByTableId.put(tableId, new TableImpl(tableId, updated.columns(), updated.primaryKeyColumnNames(), updated.defaultCharsetName()));
            }
            this.changes.add(tableId);
            return existing;
        });
    }

    public Table removeTable(TableId tableId) {
        return this.lock.write(() -> {
            this.changes.add(tableId);
            return this.tablesByTableId.remove(tableId);
        });
    }

    public Table forTable(TableId tableId) {
        return this.lock.read(() -> this.tablesByTableId.get(tableId));
    }

    public Table forTable(String catalogName, String schemaName, String tableName) {
        return this.forTable(new TableId(catalogName, schemaName, tableName));
    }

    public Set<TableId> tableIds() {
        return this.lock.read(() -> Collect.unmodifiableSet(this.tablesByTableId.ids()));
    }

    public TableEditor editTable(TableId tableId) {
        Table table = this.forTable(tableId);
        return table == null ? null : table.edit();
    }

    public TableEditor editOrCreateTable(TableId tableId) {
        Table table = this.forTable(tableId);
        return table == null ? Table.editor().tableId(tableId) : table.edit();
    }

    public int hashCode() {
        return this.tablesByTableId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Tables) {
            Tables that = (Tables)obj;
            return this.tablesByTableId.equals(that.tablesByTableId);
        }
        return false;
    }

    public Tables subset(TableFilter filter) {
        if (filter == null) {
            return this;
        }
        return this.lock.read(() -> {
            Tables result = new Tables(this.tableIdCaseInsensitive);
            this.tablesByTableId.forEach((tableId, table) -> {
                if (filter.isIncluded((TableId)tableId)) {
                    result.overwriteTable((Table)table);
                }
            });
            return result;
        });
    }

    public String toString() {
        return this.lock.read(() -> {
            StringBuilder sb = new StringBuilder();
            sb.append("Tables {");
            if (!this.tablesByTableId.isEmpty()) {
                sb.append(System.lineSeparator());
                this.tablesByTableId.forEach((tableId, table) -> {
                    sb.append("  ").append(tableId).append(": {").append(System.lineSeparator());
                    table.toString(sb, "    ");
                    sb.append("  }").append(System.lineSeparator());
                });
            }
            sb.append("}");
            return sb.toString();
        });
    }

    private static class TableIds {
        private final boolean tableIdCaseInsensitive;
        private final Set<TableId> values;

        public TableIds(boolean tableIdCaseInsensitive) {
            this.tableIdCaseInsensitive = tableIdCaseInsensitive;
            this.values = new HashSet<TableId>();
        }

        public void add(TableId tableId) {
            this.values.add(this.toLowerCaseIfNeeded(tableId));
        }

        public Set<TableId> toSet() {
            return new HashSet<TableId>(this.values);
        }

        public void clear() {
            this.values.clear();
        }

        private TableId toLowerCaseIfNeeded(TableId tableId) {
            return this.tableIdCaseInsensitive ? tableId.toLowercase() : tableId;
        }
    }

    private static class TablesById {
        private final boolean tableIdCaseInsensitive;
        private final ConcurrentMap<TableId, TableImpl> values;

        public TablesById(boolean tableIdCaseInsensitive) {
            this.tableIdCaseInsensitive = tableIdCaseInsensitive;
            this.values = new ConcurrentHashMap<TableId, TableImpl>();
        }

        public Set<TableId> ids() {
            return this.values.keySet();
        }

        boolean isEmpty() {
            return this.values.isEmpty();
        }

        public void putAll(TablesById tablesByTableId) {
            if (this.tableIdCaseInsensitive) {
                tablesByTableId.values.entrySet().forEach((? super T e) -> this.put(((TableId)e.getKey()).toLowercase(), (TableImpl)e.getValue()));
            } else {
                this.values.putAll(tablesByTableId.values);
            }
        }

        public TableImpl remove(TableId tableId) {
            return (TableImpl)this.values.remove(this.toLowerCaseIfNeeded(tableId));
        }

        public TableImpl get(TableId tableId) {
            return (TableImpl)this.values.get(this.toLowerCaseIfNeeded(tableId));
        }

        public Table put(TableId tableId, TableImpl updated) {
            return this.values.put(this.toLowerCaseIfNeeded(tableId), updated);
        }

        int size() {
            return this.values.size();
        }

        void forEach(BiConsumer<? super TableId, ? super TableImpl> action) {
            this.values.forEach(action);
        }

        Set<Map.Entry<TableId, TableImpl>> entrySet() {
            return this.values.entrySet();
        }

        void clear() {
            this.values.clear();
        }

        private TableId toLowerCaseIfNeeded(TableId tableId) {
            return this.tableIdCaseInsensitive ? tableId.toLowercase() : tableId;
        }

        public int hashCode() {
            return this.values.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TablesById other = (TablesById)obj;
            return this.values.equals(other.values);
        }
    }

    @FunctionalInterface
    public static interface ColumnNameFilter {
        public boolean matches(String var1, String var2, String var3, String var4);

        public static ColumnNameFilter getInstance(String fullyQualifiedColumnNames) {
            final Predicate<ColumnId> delegate = Predicates.excludes(fullyQualifiedColumnNames, ColumnId::toString);
            return new ColumnNameFilter(){

                @Override
                public boolean matches(String catalogName, String schemaName, String tableName, String columnName) {
                    return delegate.test(new ColumnId(new TableId(catalogName, schemaName, tableName), columnName));
                }
            };
        }
    }

    @FunctionalInterface
    public static interface TableFilter
    extends DataCollectionFilters.DataCollectionFilter<TableId> {
        @Override
        public boolean isIncluded(TableId var1);

        public static TableFilter fromPredicate(Predicate<TableId> predicate) {
            return t -> predicate.test(t);
        }

        public static TableFilter includeAll() {
            return t -> true;
        }
    }
}

