/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver.metrics;

import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.sqlserver.metrics.SqlServerPartitionMetricsMXBean;
import io.debezium.data.Envelope;
import io.debezium.metrics.Metrics;
import io.debezium.metrics.activity.ActivityMonitoringMeter;
import io.debezium.pipeline.ConnectorEvent;
import io.debezium.pipeline.meters.CommonEventMeter;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.spi.schema.DataCollectionId;
import java.util.Map;
import org.apache.kafka.connect.data.Struct;

public abstract class AbstractSqlServerPartitionMetrics
extends Metrics
implements SqlServerPartitionMetricsMXBean {
    private final CommonEventMeter commonEventMeter;
    private final ActivityMonitoringMeter activityMonitoringMeter;
    protected final CdcSourceTaskContext taskContext;

    AbstractSqlServerPartitionMetrics(CdcSourceTaskContext taskContext, Map<String, String> tags, EventMetadataProvider metadataProvider) {
        super(taskContext, tags);
        this.taskContext = taskContext;
        this.commonEventMeter = new CommonEventMeter(taskContext.getClock(), metadataProvider);
        this.activityMonitoringMeter = new ActivityMonitoringMeter();
    }

    public String getLastEvent() {
        return this.commonEventMeter.getLastEvent();
    }

    public long getMilliSecondsSinceLastEvent() {
        return this.commonEventMeter.getMilliSecondsSinceLastEvent();
    }

    public long getTotalNumberOfEventsSeen() {
        return this.commonEventMeter.getTotalNumberOfEventsSeen();
    }

    public long getTotalNumberOfCreateEventsSeen() {
        return this.commonEventMeter.getTotalNumberOfCreateEventsSeen();
    }

    public long getTotalNumberOfUpdateEventsSeen() {
        return this.commonEventMeter.getTotalNumberOfUpdateEventsSeen();
    }

    public long getTotalNumberOfDeleteEventsSeen() {
        return this.commonEventMeter.getTotalNumberOfDeleteEventsSeen();
    }

    public long getNumberOfEventsFiltered() {
        return this.commonEventMeter.getNumberOfEventsFiltered();
    }

    public long getNumberOfErroneousEvents() {
        return this.commonEventMeter.getNumberOfErroneousEvents();
    }

    public Map<String, Long> getNumberOfCreateEventsSeen() {
        return this.activityMonitoringMeter.getNumberOfCreateEventsSeen();
    }

    public Map<String, Long> getNumberOfDeleteEventsSeen() {
        return this.activityMonitoringMeter.getNumberOfDeleteEventsSeen();
    }

    public Map<String, Long> getNumberOfUpdateEventsSeen() {
        return this.activityMonitoringMeter.getNumberOfUpdateEventsSeen();
    }

    public Map<String, Long> getNumberOfTruncateEventsSeen() {
        return this.activityMonitoringMeter.getNumberOfTruncateEventsSeen();
    }

    public void pause() {
        this.activityMonitoringMeter.pause();
    }

    public void resume() {
        this.activityMonitoringMeter.resume();
    }

    void onEvent(DataCollectionId source, OffsetContext offset, Object key, Struct value, Envelope.Operation operation) {
        this.commonEventMeter.onEvent(source, offset, key, value, operation);
        if (this.taskContext.getConfig().isAdvancedMetricsEnabled()) {
            this.activityMonitoringMeter.onEvent(source, offset, key, value, operation);
        }
    }

    void onFilteredEvent(String event) {
        this.commonEventMeter.onFilteredEvent();
    }

    void onFilteredEvent(String event, Envelope.Operation operation) {
        this.commonEventMeter.onFilteredEvent(operation);
    }

    void onErroneousEvent(String event) {
        this.commonEventMeter.onErroneousEvent();
    }

    void onErroneousEvent(String event, Envelope.Operation operation) {
        this.commonEventMeter.onErroneousEvent(operation);
    }

    void onConnectorEvent(ConnectorEvent event) {
    }

    @Override
    public void reset() {
        this.commonEventMeter.reset();
        this.activityMonitoringMeter.reset();
    }
}

